/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.Random;

public class ZipfRandom {
    private final double N;
    private final double alpha;
    private final Random uniformDistribution;
    private double c;

    public ZipfRandom(double d, int n) {
        this(System.currentTimeMillis(), d, n);
    }

    public ZipfRandom(long l, double d, int n) {
        this.uniformDistribution = new Random(l);
        if (n <= 0) {
            throw new IllegalArgumentException("N must be positive");
        }
        this.N = n;
        this.alpha = d;
        for (int i = 1; i <= n; ++i) {
            this.c += 1.0 / Math.pow(i, d);
        }
        this.c = 1.0 / this.c;
    }

    public int nextInt() {
        double d = 0.0;
        double d2 = this.uniformDistribution.nextDouble();
        double d3 = 0.0;
        int n = 1;
        while ((double)n <= this.N) {
            if ((d3 += this.c / Math.pow(n, this.alpha)) >= d2) {
                d = n;
                break;
            }
            ++n;
        }
        assert (d >= 1.0 && d <= this.N);
        return (int)d;
    }
}

