/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xerial.util.io.Base64;

public class Base64InputStream
extends FilterInputStream {
    private final boolean doEncode;
    private final Base64 base64;
    private final byte[] singleByte = new byte[1];

    public Base64InputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public Base64InputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.doEncode = bl;
        this.base64 = new Base64();
    }

    public Base64InputStream(InputStream inputStream, boolean bl, int n, byte[] byArray) {
        super(inputStream);
        this.doEncode = bl;
        this.base64 = new Base64(n, byArray);
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.singleByte, 0, 1);
        while (n == 0) {
            n = this.read(this.singleByte, 0, 1);
        }
        if (n > 0) {
            return this.singleByte[0] < 0 ? 256 + this.singleByte[0] : this.singleByte[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n > byArray.length || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (!this.base64.hasData()) {
            byte[] byArray2 = new byte[this.doEncode ? 4096 : 8192];
            int n3 = this.in.read(byArray2);
            if (n3 > 0 && byArray.length == n2) {
                this.base64.setInitialBuffer(byArray, n, n2);
            }
            if (this.doEncode) {
                this.base64.encode(byArray2, 0, n3);
            } else {
                this.base64.decode(byArray2, 0, n3);
            }
        }
        return this.base64.readResults(byArray, n, n2);
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

