/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io.SevenZip.Compression.LZ;

import java.io.IOException;
import java.io.InputStream;

public class InWindow {
    public byte[] _bufferBase;
    InputStream _stream;
    int _posLimit;
    boolean _streamEndWasReached;
    int _pointerToLastSafePosition;
    public int _bufferOffset;
    public int _blockSize;
    public int _pos;
    int _keepSizeBefore;
    int _keepSizeAfter;
    public int _streamPos;

    public void MoveBlock() {
        int n = this._bufferOffset + this._pos - this._keepSizeBefore;
        if (n > 0) {
            --n;
        }
        int n2 = this._bufferOffset + this._streamPos - n;
        for (int i = 0; i < n2; ++i) {
            this._bufferBase[i] = this._bufferBase[n + i];
        }
        this._bufferOffset -= n;
    }

    public void ReadBlock() throws IOException {
        if (this._streamEndWasReached) {
            return;
        }
        int n;
        while ((n = 0 - this._bufferOffset + this._blockSize - this._streamPos) != 0) {
            int n2 = this._stream.read(this._bufferBase, this._bufferOffset + this._streamPos, n);
            if (n2 == -1) {
                this._posLimit = this._streamPos;
                int n3 = this._bufferOffset + this._posLimit;
                if (n3 > this._pointerToLastSafePosition) {
                    this._posLimit = this._pointerToLastSafePosition - this._bufferOffset;
                }
                this._streamEndWasReached = true;
                return;
            }
            this._streamPos += n2;
            if (this._streamPos < this._pos + this._keepSizeAfter) continue;
            this._posLimit = this._streamPos - this._keepSizeAfter;
        }
        return;
    }

    void Free() {
        this._bufferBase = null;
    }

    public void Create(int n, int n2, int n3) {
        this._keepSizeBefore = n;
        this._keepSizeAfter = n2;
        int n4 = n + n2 + n3;
        if (this._bufferBase == null || this._blockSize != n4) {
            this.Free();
            this._blockSize = n4;
            this._bufferBase = new byte[this._blockSize];
        }
        this._pointerToLastSafePosition = this._blockSize - n2;
    }

    public void SetStream(InputStream inputStream) {
        this._stream = inputStream;
    }

    public void ReleaseStream() {
        this._stream = null;
    }

    public void Init() throws IOException {
        this._bufferOffset = 0;
        this._pos = 0;
        this._streamPos = 0;
        this._streamEndWasReached = false;
        this.ReadBlock();
    }

    public void MovePos() throws IOException {
        ++this._pos;
        if (this._pos > this._posLimit) {
            int n = this._bufferOffset + this._pos;
            if (n > this._pointerToLastSafePosition) {
                this.MoveBlock();
            }
            this.ReadBlock();
        }
    }

    public byte GetIndexByte(int n) {
        return this._bufferBase[this._bufferOffset + this._pos + n];
    }

    public int GetMatchLen(int n, int n2, int n3) {
        int n4;
        if (this._streamEndWasReached && this._pos + n + n3 > this._streamPos) {
            n3 = this._streamPos - (this._pos + n);
        }
        ++n2;
        int n5 = this._bufferOffset + this._pos + n;
        for (n4 = 0; n4 < n3 && this._bufferBase[n5 + n4] == this._bufferBase[n5 + n4 - n2]; ++n4) {
        }
        return n4;
    }

    public int GetNumAvailableBytes() {
        return this._streamPos - this._pos;
    }

    public void ReduceOffsets(int n) {
        this._bufferOffset += n;
        this._posLimit -= n;
        this._pos -= n;
        this._streamPos -= n;
    }
}

