/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.StringUtil;
import org.xerial.util.log.Logger;
import org.xerial.util.text.TabSeparatedTextWalker;
import org.xerial.util.tree.TreeEventHandler;
import org.xerial.util.tree.TreeNode;
import org.xerial.util.tree.TreeParser;

public class TabAsTreeParser
implements TreeParser {
    private static Logger _logger = Logger.getLogger(TabSeparatedTextWalker.class);
    private boolean isFirstLineContainsColumnLabel = false;
    private boolean reportLineNumber = false;
    private final BufferedReader reader;
    private final String rootName = "root";
    private String rowName = "entry";
    private String lineAttributeName = "line";
    private final char separator;
    private int lineCount = -1;
    private final ArrayList<String> columnLableList = new ArrayList();

    public TabAsTreeParser(Reader reader) {
        this(reader, '\t');
    }

    public TabAsTreeParser(Reader reader, char c) {
        this.reader = new BufferedReader(reader);
        this.separator = c;
    }

    public void setFirstLineAsColumnLabel(boolean bl) {
        this.isFirstLineContainsColumnLabel = bl;
    }

    public void setRowNodeName(String string) {
        this.rowName = string;
    }

    public String getRowNodeName() {
        return this.rowName;
    }

    public void setColunLabel(List<String> list) {
        this.columnLableList.clear();
        for (String string : list) {
            this.columnLableList.add(string);
        }
    }

    public TreeNode getSubTree() throws XerialException {
        throw new UnsupportedOperationException("getSubTree()");
    }

    public void skipDescendants() {
        throw new UnsupportedOperationException("skipDescendants()");
    }

    private String readLine() throws IOException {
        String string = this.reader.readLine();
        ++this.lineCount;
        return string;
    }

    @Override
    public void parse(TreeEventHandler treeEventHandler) throws Exception {
        this.lineCount = -1;
        treeEventHandler.init();
        treeEventHandler.visitNode("root", null);
        try {
            String string;
            Object object;
            Object object2;
            if (this.isFirstLineContainsColumnLabel) {
                object2 = this.splitLine(this.readLine());
                int n = 1;
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    if (string.length() <= 0) {
                        string = "c" + n;
                        _logger.warn(String.format("column (index=%d) has no column label. Use %s instead.", n, string));
                    }
                    this.columnLableList.add(string);
                    ++n;
                }
            }
            object2 = this.readLine();
            while (object2 != null) {
                ArrayList<String> arrayList = this.splitLine((String)object2);
                if (arrayList != null && arrayList.size() > 0) {
                    treeEventHandler.visitNode(this.rowName, null);
                    if (this.reportLineNumber) {
                        object = Integer.toString(this.lineCount);
                        treeEventHandler.visitNode(this.lineAttributeName, (String)object);
                        treeEventHandler.leaveNode(this.lineAttributeName);
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        string = this.getColumnLabel(i);
                        String string2 = TabAsTreeParser.escapeText(arrayList.get(i));
                        treeEventHandler.visitNode(string, string2);
                        treeEventHandler.leaveNode(string);
                    }
                    treeEventHandler.leaveNode(this.rowName);
                }
                object2 = this.readLine();
            }
        }
        catch (IOException iOException) {
            throw new XerialException((ErrorCode)XerialErrorCode.READ_ERROR, (Throwable)iOException);
        }
        treeEventHandler.leaveNode("root");
        treeEventHandler.finish();
    }

    public static String escapeText(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&#39;");
        return string;
    }

    public boolean isReportLineNumber() {
        return this.reportLineNumber;
    }

    public void setReportLineNumber(boolean bl) {
        this.reportLineNumber = bl;
    }

    public String getLineAttributeName() {
        return this.lineAttributeName;
    }

    public void setLineAttributeName(String string) {
        this.lineAttributeName = string;
    }

    private ArrayList<String> splitLine(String string) {
        if (string.length() <= 0) {
            return null;
        }
        return StringUtil.split(string, this.separator);
    }

    public String getColumnLabel(int n) {
        if (n < this.columnLableList.size()) {
            return this.columnLableList.get(n);
        }
        for (int i = this.columnLableList.size(); i <= n; ++i) {
            this.columnLableList.add("c" + (i + 1));
        }
        return this.getColumnLabel(n);
    }

    public List<String> getColumnLabelList() {
        return this.columnLableList;
    }
}

