/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.com.yammer.metrics.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.$internal.com.yammer.metrics.core.Clock;
import org.apache.pinot.$internal.com.yammer.metrics.core.Counter;
import org.apache.pinot.$internal.com.yammer.metrics.core.Gauge;
import org.apache.pinot.$internal.com.yammer.metrics.core.Histogram;
import org.apache.pinot.$internal.com.yammer.metrics.core.Meter;
import org.apache.pinot.$internal.com.yammer.metrics.core.Metric;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricPredicate;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistryListener;
import org.apache.pinot.$internal.com.yammer.metrics.core.Stoppable;
import org.apache.pinot.$internal.com.yammer.metrics.core.ThreadPools;
import org.apache.pinot.$internal.com.yammer.metrics.core.Timer;

public class MetricsRegistry {
    private static final int EXPECTED_METRIC_COUNT = 1024;
    private final Clock clock;
    private final ConcurrentMap<MetricName, Metric> metrics;
    private final ThreadPools threadPools;
    private final List<MetricsRegistryListener> listeners;

    public MetricsRegistry() {
        this(Clock.defaultClock());
    }

    public MetricsRegistry(Clock clock) {
        this.clock = clock;
        this.metrics = this.newMetricsMap();
        this.threadPools = new ThreadPools();
        this.listeners = new CopyOnWriteArrayList<MetricsRegistryListener>();
    }

    public <T> Gauge<T> newGauge(Class<?> klass, String name, Gauge<T> metric) {
        return this.newGauge(klass, name, null, metric);
    }

    public <T> Gauge<T> newGauge(Class<?> klass, String name, String scope, Gauge<T> metric) {
        return this.newGauge(this.createName(klass, name, scope), metric);
    }

    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return this.getOrAdd(metricName, metric);
    }

    public Counter newCounter(Class<?> klass, String name) {
        return this.newCounter(klass, name, null);
    }

    public Counter newCounter(Class<?> klass, String name, String scope) {
        return this.newCounter(this.createName(klass, name, scope));
    }

    public Counter newCounter(MetricName metricName) {
        return this.getOrAdd(metricName, new Counter());
    }

    public Histogram newHistogram(Class<?> klass, String name, boolean biased) {
        return this.newHistogram(klass, name, null, biased);
    }

    public Histogram newHistogram(Class<?> klass, String name, String scope, boolean biased) {
        return this.newHistogram(this.createName(klass, name, scope), biased);
    }

    public Histogram newHistogram(Class<?> klass, String name) {
        return this.newHistogram(klass, name, false);
    }

    public Histogram newHistogram(Class<?> klass, String name, String scope) {
        return this.newHistogram(klass, name, scope, false);
    }

    public Histogram newHistogram(MetricName metricName, boolean biased) {
        return this.getOrAdd(metricName, new Histogram(biased ? Histogram.SampleType.BIASED : Histogram.SampleType.UNIFORM));
    }

    public Meter newMeter(Class<?> klass, String name, String eventType, TimeUnit unit) {
        return this.newMeter(klass, name, null, eventType, unit);
    }

    public Meter newMeter(Class<?> klass, String name, String scope, String eventType, TimeUnit unit) {
        return this.newMeter(this.createName(klass, name, scope), eventType, unit);
    }

    public Meter newMeter(MetricName metricName, String eventType, TimeUnit unit) {
        Metric existingMetric = (Metric)this.metrics.get(metricName);
        if (existingMetric != null) {
            return (Meter)existingMetric;
        }
        return this.getOrAdd(metricName, new Meter(this.newMeterTickThreadPool(), eventType, unit, this.clock));
    }

    public Timer newTimer(Class<?> klass, String name) {
        return this.newTimer(klass, name, null, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public Timer newTimer(Class<?> klass, String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return this.newTimer(klass, name, null, durationUnit, rateUnit);
    }

    public Timer newTimer(Class<?> klass, String name, String scope) {
        return this.newTimer(klass, name, scope, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public Timer newTimer(Class<?> klass, String name, String scope, TimeUnit durationUnit, TimeUnit rateUnit) {
        return this.newTimer(this.createName(klass, name, scope), durationUnit, rateUnit);
    }

    public Timer newTimer(MetricName metricName, TimeUnit durationUnit, TimeUnit rateUnit) {
        Metric existingMetric = (Metric)this.metrics.get(metricName);
        if (existingMetric != null) {
            return (Timer)existingMetric;
        }
        return this.getOrAdd(metricName, new Timer(this.newMeterTickThreadPool(), durationUnit, rateUnit, this.clock));
    }

    public Map<MetricName, Metric> allMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public SortedMap<String, SortedMap<MetricName, Metric>> groupedMetrics() {
        return this.groupedMetrics(MetricPredicate.ALL);
    }

    public SortedMap<String, SortedMap<MetricName, Metric>> groupedMetrics(MetricPredicate predicate) {
        TreeMap groups = new TreeMap();
        for (Map.Entry entry : this.metrics.entrySet()) {
            String qualifiedTypeName = ((MetricName)entry.getKey()).getGroup() + "." + ((MetricName)entry.getKey()).getType();
            if (!predicate.matches((MetricName)entry.getKey(), (Metric)entry.getValue())) continue;
            String scopedName = ((MetricName)entry.getKey()).hasScope() ? qualifiedTypeName + "." + ((MetricName)entry.getKey()).getScope() : qualifiedTypeName;
            TreeMap group = (TreeMap)groups.get(scopedName);
            if (group == null) {
                group = new TreeMap();
                groups.put(scopedName, group);
            }
            group.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableSortedMap(groups);
    }

    public void shutdown() {
        this.threadPools.shutdown();
    }

    public ScheduledExecutorService newScheduledThreadPool(int poolSize, String name) {
        return this.threadPools.newScheduledThreadPool(poolSize, name);
    }

    public void removeMetric(Class<?> klass, String name) {
        this.removeMetric(klass, name, null);
    }

    public void removeMetric(Class<?> klass, String name, String scope) {
        this.removeMetric(this.createName(klass, name, scope));
    }

    public void removeMetric(MetricName name) {
        Metric metric = (Metric)this.metrics.remove(name);
        if (metric != null) {
            if (metric instanceof Stoppable) {
                ((Stoppable)((Object)metric)).stop();
            }
            this.notifyMetricRemoved(name);
        }
    }

    public void addListener(MetricsRegistryListener listener) {
        this.listeners.add(listener);
        for (Map.Entry entry : this.metrics.entrySet()) {
            listener.onMetricAdded((MetricName)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public void removeListener(MetricsRegistryListener listener) {
        this.listeners.remove(listener);
    }

    protected MetricName createName(Class<?> klass, String name, String scope) {
        return new MetricName(klass, name, scope);
    }

    protected ConcurrentMap<MetricName, Metric> newMetricsMap() {
        return new ConcurrentHashMap<MetricName, Metric>(1024);
    }

    protected final <T extends Metric> T getOrAdd(MetricName name, T metric) {
        Metric existingMetric = (Metric)this.metrics.get(name);
        if (existingMetric == null) {
            Metric justAddedMetric = this.metrics.putIfAbsent(name, metric);
            if (justAddedMetric == null) {
                this.notifyMetricAdded(name, metric);
                return metric;
            }
            if (metric instanceof Stoppable) {
                ((Stoppable)((Object)metric)).stop();
            }
            return (T)justAddedMetric;
        }
        return (T)existingMetric;
    }

    private ScheduledExecutorService newMeterTickThreadPool() {
        return this.threadPools.newScheduledThreadPool(2, "meter-tick");
    }

    private void notifyMetricRemoved(MetricName name) {
        for (MetricsRegistryListener listener : this.listeners) {
            listener.onMetricRemoved(name);
        }
    }

    private void notifyMetricAdded(MetricName name, Metric metric) {
        for (MetricsRegistryListener listener : this.listeners) {
            listener.onMetricAdded(name, metric);
        }
    }
}

