/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.io.netty.handler.proxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.pinot.$internal.io.netty.buffer.ByteBuf;
import org.apache.pinot.$internal.io.netty.buffer.Unpooled;
import org.apache.pinot.$internal.io.netty.channel.ChannelHandlerContext;
import org.apache.pinot.$internal.io.netty.channel.ChannelPipeline;
import org.apache.pinot.$internal.io.netty.handler.codec.base64.Base64;
import org.apache.pinot.$internal.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.pinot.$internal.io.netty.handler.codec.http.HttpClientCodec;
import org.apache.pinot.$internal.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.pinot.$internal.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pinot.$internal.io.netty.handler.codec.http.HttpMethod;
import org.apache.pinot.$internal.io.netty.handler.codec.http.HttpResponse;
import org.apache.pinot.$internal.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.pinot.$internal.io.netty.handler.codec.http.HttpUtil;
import org.apache.pinot.$internal.io.netty.handler.codec.http.HttpVersion;
import org.apache.pinot.$internal.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pinot.$internal.io.netty.handler.proxy.ProxyConnectException;
import org.apache.pinot.$internal.io.netty.handler.proxy.ProxyHandler;
import org.apache.pinot.$internal.io.netty.util.AsciiString;
import org.apache.pinot.$internal.io.netty.util.CharsetUtil;

public final class HttpProxyHandler
extends ProxyHandler {
    private static final String PROTOCOL = "http";
    private static final String AUTH_BASIC = "basic";
    private final HttpClientCodec codec = new HttpClientCodec();
    private final String username;
    private final String password;
    private final CharSequence authorization;
    private final HttpHeaders outboundHeaders;
    private final boolean ignoreDefaultPortsInConnectHostHeader;
    private HttpResponseStatus status;
    private HttpHeaders inboundHeaders;

    public HttpProxyHandler(SocketAddress proxyAddress) {
        this(proxyAddress, null);
    }

    public HttpProxyHandler(SocketAddress proxyAddress, HttpHeaders headers) {
        this(proxyAddress, headers, false);
    }

    public HttpProxyHandler(SocketAddress proxyAddress, HttpHeaders headers, boolean ignoreDefaultPortsInConnectHostHeader) {
        super(proxyAddress);
        this.username = null;
        this.password = null;
        this.authorization = null;
        this.outboundHeaders = headers;
        this.ignoreDefaultPortsInConnectHostHeader = ignoreDefaultPortsInConnectHostHeader;
    }

    public HttpProxyHandler(SocketAddress proxyAddress, String username, String password) {
        this(proxyAddress, username, password, null);
    }

    public HttpProxyHandler(SocketAddress proxyAddress, String username, String password, HttpHeaders headers) {
        this(proxyAddress, username, password, headers, false);
    }

    public HttpProxyHandler(SocketAddress proxyAddress, String username, String password, HttpHeaders headers, boolean ignoreDefaultPortsInConnectHostHeader) {
        super(proxyAddress);
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        this.username = username;
        this.password = password;
        ByteBuf authz = Unpooled.copiedBuffer(username + ':' + password, CharsetUtil.UTF_8);
        ByteBuf authzBase64 = Base64.encode(authz, false);
        this.authorization = new AsciiString("Basic " + authzBase64.toString(CharsetUtil.US_ASCII));
        authz.release();
        authzBase64.release();
        this.outboundHeaders = headers;
        this.ignoreDefaultPortsInConnectHostHeader = ignoreDefaultPortsInConnectHostHeader;
    }

    @Override
    public String protocol() {
        return PROTOCOL;
    }

    @Override
    public String authScheme() {
        return this.authorization != null ? AUTH_BASIC : "none";
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    @Override
    protected void addCodec(ChannelHandlerContext ctx) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        String name = ctx.name();
        p.addBefore(name, null, this.codec);
    }

    @Override
    protected void removeEncoder(ChannelHandlerContext ctx) throws Exception {
        this.codec.removeOutboundHandler();
    }

    @Override
    protected void removeDecoder(ChannelHandlerContext ctx) throws Exception {
        this.codec.removeInboundHandler();
    }

    @Override
    protected Object newInitialMessage(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress raddr = (InetSocketAddress)this.destinationAddress();
        String hostString = HttpUtil.formatHostnameForHttp(raddr);
        int port = raddr.getPort();
        String url = hostString + ":" + port;
        String hostHeader = this.ignoreDefaultPortsInConnectHostHeader && (port == 80 || port == 443) ? hostString : url;
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, url, Unpooled.EMPTY_BUFFER, false);
        req.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)hostHeader);
        if (this.authorization != null) {
            req.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)this.authorization);
        }
        if (this.outboundHeaders != null) {
            req.headers().add(this.outboundHeaders);
        }
        return req;
    }

    @Override
    protected boolean handleResponse(ChannelHandlerContext ctx, Object response) throws Exception {
        boolean finished;
        if (response instanceof HttpResponse) {
            if (this.status != null) {
                throw new HttpProxyConnectException(this.exceptionMessage("too many responses"), null);
            }
            HttpResponse res = (HttpResponse)response;
            this.status = res.status();
            this.inboundHeaders = res.headers();
        }
        if (finished = response instanceof LastHttpContent) {
            if (this.status == null) {
                throw new HttpProxyConnectException(this.exceptionMessage("missing response"), this.inboundHeaders);
            }
            if (this.status.code() != 200) {
                throw new HttpProxyConnectException(this.exceptionMessage("status: " + this.status), this.inboundHeaders);
            }
        }
        return finished;
    }

    public static final class HttpProxyConnectException
    extends ProxyConnectException {
        private static final long serialVersionUID = -8824334609292146066L;
        private final HttpHeaders headers;

        public HttpProxyConnectException(String message, HttpHeaders headers) {
            super(message);
            this.headers = headers;
        }

        public HttpHeaders headers() {
            return this.headers;
        }
    }
}

