/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.pinot.$internal.org.apache.commons.csv.CSVParser;
import org.apache.pinot.$internal.org.apache.commons.csv.CSVPrinter;
import org.apache.pinot.$internal.org.apache.commons.csv.Constants;
import org.apache.pinot.$internal.org.apache.commons.csv.QuoteMode;

public final class CSVFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final char delimiter;
    private final Character quoteCharacter;
    private final QuoteMode quoteMode;
    private final Character commentMarker;
    private final Character escapeCharacter;
    private final boolean ignoreSurroundingSpaces;
    private final boolean allowMissingColumnNames;
    private final boolean ignoreEmptyLines;
    private final String recordSeparator;
    private final String nullString;
    private final String[] header;
    private final boolean skipHeaderRecord;
    public static final CSVFormat DEFAULT = new CSVFormat(',', Constants.DOUBLE_QUOTE_CHAR, null, null, null, false, true, "\r\n", null, null, false, false);
    public static final CSVFormat RFC4180 = DEFAULT.withIgnoreEmptyLines(false);
    public static final CSVFormat EXCEL = DEFAULT.withIgnoreEmptyLines(false);
    public static final CSVFormat TDF = DEFAULT.withDelimiter('\t').withIgnoreSurroundingSpaces(true);
    public static final CSVFormat MYSQL = DEFAULT.withDelimiter('\t').withEscape('\\').withIgnoreEmptyLines(false).withQuote(null).withRecordSeparator('\n');

    private static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    private static boolean isLineBreak(Character c) {
        return c != null && CSVFormat.isLineBreak(c.charValue());
    }

    public static CSVFormat newFormat(char delimiter) {
        return new CSVFormat(delimiter, null, null, null, null, false, false, null, null, null, false, false);
    }

    private CSVFormat(char delimiter, Character quoteChar, QuoteMode quoteMode, Character commentStart, Character escape, boolean ignoreSurroundingSpaces, boolean ignoreEmptyLines, String recordSeparator, String nullString, String[] header, boolean skipHeaderRecord, boolean allowMissingColumnNames) {
        if (CSVFormat.isLineBreak(delimiter)) {
            throw new IllegalArgumentException("The delimiter cannot be a line break");
        }
        this.delimiter = delimiter;
        this.quoteCharacter = quoteChar;
        this.quoteMode = quoteMode;
        this.commentMarker = commentStart;
        this.escapeCharacter = escape;
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
        this.allowMissingColumnNames = allowMissingColumnNames;
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.recordSeparator = recordSeparator;
        this.nullString = nullString;
        if (header == null) {
            this.header = null;
        } else {
            HashSet<String> dupCheck = new HashSet<String>();
            for (String hdr : header) {
                if (dupCheck.add(hdr)) continue;
                throw new IllegalArgumentException("The header contains a duplicate entry: '" + hdr + "' in " + Arrays.toString(header));
            }
            this.header = (String[])header.clone();
        }
        this.skipHeaderRecord = skipHeaderRecord;
        this.validate();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSVFormat other = (CSVFormat)obj;
        if (this.delimiter != other.delimiter) {
            return false;
        }
        if (this.quoteMode != other.quoteMode) {
            return false;
        }
        if (this.quoteCharacter == null ? other.quoteCharacter != null : !this.quoteCharacter.equals(other.quoteCharacter)) {
            return false;
        }
        if (this.commentMarker == null ? other.commentMarker != null : !this.commentMarker.equals(other.commentMarker)) {
            return false;
        }
        if (this.escapeCharacter == null ? other.escapeCharacter != null : !this.escapeCharacter.equals(other.escapeCharacter)) {
            return false;
        }
        if (this.nullString == null ? other.nullString != null : !this.nullString.equals(other.nullString)) {
            return false;
        }
        if (!Arrays.equals(this.header, other.header)) {
            return false;
        }
        if (this.ignoreSurroundingSpaces != other.ignoreSurroundingSpaces) {
            return false;
        }
        if (this.ignoreEmptyLines != other.ignoreEmptyLines) {
            return false;
        }
        if (this.skipHeaderRecord != other.skipHeaderRecord) {
            return false;
        }
        return !(this.recordSeparator == null ? other.recordSeparator != null : !this.recordSeparator.equals(other.recordSeparator));
    }

    public String format(Object ... values) {
        StringWriter out = new StringWriter();
        try {
            new CSVPrinter(out, this).printRecord(values);
            return out.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Character getCommentMarker() {
        return this.commentMarker;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public String[] getHeader() {
        return this.header != null ? (String[])this.header.clone() : null;
    }

    public boolean getAllowMissingColumnNames() {
        return this.allowMissingColumnNames;
    }

    public boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public boolean getIgnoreSurroundingSpaces() {
        return this.ignoreSurroundingSpaces;
    }

    public String getNullString() {
        return this.nullString;
    }

    public Character getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public QuoteMode getQuoteMode() {
        return this.quoteMode;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public boolean getSkipHeaderRecord() {
        return this.skipHeaderRecord;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delimiter;
        result = 31 * result + (this.quoteMode == null ? 0 : this.quoteMode.hashCode());
        result = 31 * result + (this.quoteCharacter == null ? 0 : this.quoteCharacter.hashCode());
        result = 31 * result + (this.commentMarker == null ? 0 : this.commentMarker.hashCode());
        result = 31 * result + (this.escapeCharacter == null ? 0 : this.escapeCharacter.hashCode());
        result = 31 * result + (this.nullString == null ? 0 : this.nullString.hashCode());
        result = 31 * result + (this.ignoreSurroundingSpaces ? 1231 : 1237);
        result = 31 * result + (this.ignoreEmptyLines ? 1231 : 1237);
        result = 31 * result + (this.skipHeaderRecord ? 1231 : 1237);
        result = 31 * result + (this.recordSeparator == null ? 0 : this.recordSeparator.hashCode());
        result = 31 * result + Arrays.hashCode(this.header);
        return result;
    }

    public boolean isCommentMarkerSet() {
        return this.commentMarker != null;
    }

    public boolean isEscapeCharacterSet() {
        return this.escapeCharacter != null;
    }

    public boolean isNullStringSet() {
        return this.nullString != null;
    }

    public boolean isQuoteCharacterSet() {
        return this.quoteCharacter != null;
    }

    public CSVParser parse(Reader in) throws IOException {
        return new CSVParser(in, this);
    }

    public CSVPrinter print(Appendable out) throws IOException {
        return new CSVPrinter(out, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Delimiter=<").append(this.delimiter).append('>');
        if (this.isEscapeCharacterSet()) {
            sb.append(' ');
            sb.append("Escape=<").append(this.escapeCharacter).append('>');
        }
        if (this.isQuoteCharacterSet()) {
            sb.append(' ');
            sb.append("QuoteChar=<").append(this.quoteCharacter).append('>');
        }
        if (this.isCommentMarkerSet()) {
            sb.append(' ');
            sb.append("CommentStart=<").append(this.commentMarker).append('>');
        }
        if (this.isNullStringSet()) {
            sb.append(' ');
            sb.append("NullString=<").append(this.nullString).append('>');
        }
        if (this.recordSeparator != null) {
            sb.append(' ');
            sb.append("RecordSeparator=<").append(this.recordSeparator).append('>');
        }
        if (this.getIgnoreEmptyLines()) {
            sb.append(" EmptyLines:ignored");
        }
        if (this.getIgnoreSurroundingSpaces()) {
            sb.append(" SurroundingSpaces:ignored");
        }
        sb.append(" SkipHeaderRecord:").append(this.skipHeaderRecord);
        if (this.header != null) {
            sb.append(' ');
            sb.append("Header:").append(Arrays.toString(this.header));
        }
        return sb.toString();
    }

    private void validate() throws IllegalArgumentException {
        if (this.quoteCharacter != null && this.delimiter == this.quoteCharacter.charValue()) {
            throw new IllegalArgumentException("The quoteChar character and the delimiter cannot be the same ('" + this.quoteCharacter + "')");
        }
        if (this.escapeCharacter != null && this.delimiter == this.escapeCharacter.charValue()) {
            throw new IllegalArgumentException("The escape character and the delimiter cannot be the same ('" + this.escapeCharacter + "')");
        }
        if (this.commentMarker != null && this.delimiter == this.commentMarker.charValue()) {
            throw new IllegalArgumentException("The comment start character and the delimiter cannot be the same ('" + this.commentMarker + "')");
        }
        if (this.quoteCharacter != null && this.quoteCharacter.equals(this.commentMarker)) {
            throw new IllegalArgumentException("The comment start character and the quoteChar cannot be the same ('" + this.commentMarker + "')");
        }
        if (this.escapeCharacter != null && this.escapeCharacter.equals(this.commentMarker)) {
            throw new IllegalArgumentException("The comment start and the escape character cannot be the same ('" + this.commentMarker + "')");
        }
        if (this.escapeCharacter == null && this.quoteMode == QuoteMode.NONE) {
            throw new IllegalArgumentException("No quotes mode set but no escape character is set");
        }
    }

    public CSVFormat withCommentMarker(char commentMarker) {
        return this.withCommentMarker(Character.valueOf(commentMarker));
    }

    public CSVFormat withCommentMarker(Character commentMarker) {
        if (CSVFormat.isLineBreak(commentMarker)) {
            throw new IllegalArgumentException("The comment start marker character cannot be a line break");
        }
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withDelimiter(char delimiter) {
        if (CSVFormat.isLineBreak(delimiter)) {
            throw new IllegalArgumentException("The delimiter cannot be a line break");
        }
        return new CSVFormat(delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withEscape(char escape) {
        return this.withEscape(Character.valueOf(escape));
    }

    public CSVFormat withEscape(Character escape) {
        if (CSVFormat.isLineBreak(escape)) {
            throw new IllegalArgumentException("The escape character cannot be a line break");
        }
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withHeader(String ... header) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withAllowMissingColumnNames(boolean allowMissingColumnNames) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, allowMissingColumnNames);
    }

    public CSVFormat withIgnoreEmptyLines(boolean ignoreEmptyLines) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withIgnoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withNullString(String nullString) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, nullString, this.header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withQuote(char quoteChar) {
        return this.withQuote(Character.valueOf(quoteChar));
    }

    public CSVFormat withQuote(Character quoteChar) {
        if (CSVFormat.isLineBreak(quoteChar)) {
            throw new IllegalArgumentException("The quoteChar cannot be a line break");
        }
        return new CSVFormat(this.delimiter, quoteChar, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withQuoteMode(QuoteMode quoteModePolicy) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, quoteModePolicy, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withRecordSeparator(char recordSeparator) {
        return this.withRecordSeparator(String.valueOf(recordSeparator));
    }

    public CSVFormat withRecordSeparator(String recordSeparator) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, recordSeparator, this.nullString, this.header, this.skipHeaderRecord, this.allowMissingColumnNames);
    }

    public CSVFormat withSkipHeaderRecord(boolean skipHeaderRecord) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.header, skipHeaderRecord, this.allowMissingColumnNames);
    }
}

