/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.pinot.$internal.org.apache.commons.math.MathException;
import org.apache.pinot.$internal.org.apache.commons.math.MathRuntimeException;
import org.apache.pinot.$internal.org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.pinot.$internal.org.apache.commons.math.distribution.TDistribution;
import org.apache.pinot.$internal.org.apache.commons.math.special.Beta;
import org.apache.pinot.$internal.org.apache.commons.math.special.Gamma;

public class TDistributionImpl
extends AbstractContinuousDistribution
implements TDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -5852615386664158222L;
    private double degreesOfFreedom;
    private final double solverAbsoluteAccuracy;

    public TDistributionImpl(double degreesOfFreedom, double inverseCumAccuracy) {
        this.setDegreesOfFreedomInternal(degreesOfFreedom);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public TDistributionImpl(double degreesOfFreedom) {
        this(degreesOfFreedom, 1.0E-9);
    }

    @Deprecated
    public void setDegreesOfFreedom(double degreesOfFreedom) {
        this.setDegreesOfFreedomInternal(degreesOfFreedom);
    }

    private void setDegreesOfFreedomInternal(double newDegreesOfFreedom) {
        if (newDegreesOfFreedom <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("degrees of freedom must be positive ({0})", newDegreesOfFreedom);
        }
        this.degreesOfFreedom = newDegreesOfFreedom;
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public double density(double x) {
        double n = this.degreesOfFreedom;
        double nPlus1Over2 = (n + 1.0) / 2.0;
        return Math.exp(Gamma.logGamma(nPlus1Over2) - 0.5 * (Math.log(Math.PI) + Math.log(n)) - Gamma.logGamma(n / 2.0) - nPlus1Over2 * Math.log(1.0 + x * x / n));
    }

    public double cumulativeProbability(double x) throws MathException {
        double ret;
        if (x == 0.0) {
            ret = 0.5;
        } else {
            double t = Beta.regularizedBeta(this.degreesOfFreedom / (this.degreesOfFreedom + x * x), 0.5 * this.degreesOfFreedom, 0.5);
            ret = x < 0.0 ? 0.5 * t : 1.0 - 0.5 * t;
        }
        return ret;
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    protected double getDomainLowerBound(double p) {
        return -1.7976931348623157E308;
    }

    protected double getDomainUpperBound(double p) {
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p) {
        return 0.0;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

