/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.org.apache.commons.math.genetics.AbstractListChromosome;
import org.apache.pinot.$internal.org.apache.commons.math.genetics.Chromosome;
import org.apache.pinot.$internal.org.apache.commons.math.genetics.ChromosomePair;
import org.apache.pinot.$internal.org.apache.commons.math.genetics.CrossoverPolicy;
import org.apache.pinot.$internal.org.apache.commons.math.genetics.GeneticAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnePointCrossover<T>
implements CrossoverPolicy {
    @Override
    public ChromosomePair crossover(Chromosome first, Chromosome second) {
        if (!(first instanceof AbstractListChromosome) || !(second instanceof AbstractListChromosome)) {
            throw new IllegalArgumentException("One point crossover works on FixedLengthChromosomes only.");
        }
        return this.crossover((AbstractListChromosome)first, (AbstractListChromosome)second);
    }

    private ChromosomePair crossover(AbstractListChromosome<T> first, AbstractListChromosome<T> second) {
        int i;
        int length = first.getLength();
        if (length != second.getLength()) {
            throw new IllegalArgumentException("Both chromosomes must have same lengths.");
        }
        List<T> parent1Rep = first.getRepresentation();
        List<T> parent2Rep = second.getRepresentation();
        ArrayList<T> child1Rep = new ArrayList<T>(first.getLength());
        ArrayList<T> child2Rep = new ArrayList<T>(second.getLength());
        int crossoverIndex = 1 + GeneticAlgorithm.getRandomGenerator().nextInt(length - 2);
        for (i = 0; i < crossoverIndex; ++i) {
            child1Rep.add(parent1Rep.get(i));
            child2Rep.add(parent2Rep.get(i));
        }
        for (i = crossoverIndex; i < length; ++i) {
            child1Rep.add(parent2Rep.get(i));
            child2Rep.add(parent1Rep.get(i));
        }
        return new ChromosomePair(first.newFixedLengthChromosome(child1Rep), second.newFixedLengthChromosome(child2Rep));
    }
}

