/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.commons.math.MathRuntimeException;
import org.apache.pinot.$internal.org.apache.commons.math.linear.AbstractRealMatrix;
import org.apache.pinot.$internal.org.apache.commons.math.linear.MatrixIndexException;
import org.apache.pinot.$internal.org.apache.commons.math.linear.MatrixUtils;
import org.apache.pinot.$internal.org.apache.commons.math.linear.RealMatrix;
import org.apache.pinot.$internal.org.apache.commons.math.linear.RealMatrixChangingVisitor;
import org.apache.pinot.$internal.org.apache.commons.math.linear.RealMatrixPreservingVisitor;

public class Array2DRowRealMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = -1067294169172445528L;
    private static final String AT_LEAST_ONE_ROW_MESSAGE = "matrix must have at least one row";
    private static final String AT_LEAST_ONE_COLUMN_MESSAGE = "matrix must have at least one column";
    private static final String DIFFERENT_ROWS_LENGTHS_MESSAGE = "some rows have length {0} while others have length {1}";
    private static final String NO_ENTRY_MESSAGE = "no entry at indices ({0}, {1}) in a {2}x{3} matrix";
    private static final String VECTOR_LENGTHS_MISMATCH = "vector length mismatch: got {0} but expected {1}";
    protected double[][] data;

    public Array2DRowRealMatrix() {
    }

    public Array2DRowRealMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        super(rowDimension, columnDimension);
        this.data = new double[rowDimension][columnDimension];
    }

    public Array2DRowRealMatrix(double[][] d) throws IllegalArgumentException, NullPointerException {
        this.copyIn(d);
    }

    public Array2DRowRealMatrix(double[][] d, boolean copyArray) throws IllegalArgumentException, NullPointerException {
        if (copyArray) {
            this.copyIn(d);
        } else {
            if (d == null) {
                throw new NullPointerException();
            }
            int nRows = d.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(AT_LEAST_ONE_ROW_MESSAGE, new Object[0]);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(AT_LEAST_ONE_COLUMN_MESSAGE, new Object[0]);
            }
            for (int r = 1; r < nRows; ++r) {
                if (d[r].length == nCols) continue;
                throw MathRuntimeException.createIllegalArgumentException(DIFFERENT_ROWS_LENGTHS_MESSAGE, nCols, d[r].length);
            }
            this.data = d;
        }
    }

    public Array2DRowRealMatrix(double[] v) {
        int nRows = v.length;
        this.data = new double[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v[row];
        }
    }

    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        return new Array2DRowRealMatrix(rowDimension, columnDimension);
    }

    public RealMatrix copy() {
        return new Array2DRowRealMatrix(this.copyOut(), false);
    }

    public RealMatrix add(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.add((Array2DRowRealMatrix)m);
        }
        catch (ClassCastException cce) {
            return super.add(m);
        }
    }

    public Array2DRowRealMatrix add(Array2DRowRealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            double[] dataRow = this.data[row];
            double[] mRow = m.data[row];
            double[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col] + mRow[col];
            }
        }
        return new Array2DRowRealMatrix(outData, false);
    }

    public RealMatrix subtract(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.subtract((Array2DRowRealMatrix)m);
        }
        catch (ClassCastException cce) {
            return super.subtract(m);
        }
    }

    public Array2DRowRealMatrix subtract(Array2DRowRealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            double[] dataRow = this.data[row];
            double[] mRow = m.data[row];
            double[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col] - mRow[col];
            }
        }
        return new Array2DRowRealMatrix(outData, false);
    }

    public RealMatrix multiply(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.multiply((Array2DRowRealMatrix)m);
        }
        catch (ClassCastException cce) {
            return super.multiply(m);
        }
    }

    public Array2DRowRealMatrix multiply(Array2DRowRealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        double[][] outData = new double[nRows][nCols];
        for (int row = 0; row < nRows; ++row) {
            double[] dataRow = this.data[row];
            double[] outDataRow = outData[row];
            for (int col = 0; col < nCols; ++col) {
                double sum = 0.0;
                for (int i = 0; i < nSum; ++i) {
                    sum += dataRow[i] * m.data[i][col];
                }
                outDataRow[col] = sum;
            }
        }
        return new Array2DRowRealMatrix(outData, false);
    }

    public double[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataRef() {
        return this.data;
    }

    public void setSubMatrix(double[][] subMatrix, int row, int column) throws MatrixIndexException {
        if (this.data == null) {
            if (row > 0) {
                throw MathRuntimeException.createIllegalStateException("first {0} rows are not initialized yet", row);
            }
            if (column > 0) {
                throw MathRuntimeException.createIllegalStateException("first {0} columns are not initialized yet", column);
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(AT_LEAST_ONE_ROW_MESSAGE, new Object[0]);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(AT_LEAST_ONE_COLUMN_MESSAGE, new Object[0]);
            }
            this.data = new double[subMatrix.length][nCols];
            for (int i = 0; i < this.data.length; ++i) {
                if (subMatrix[i].length != nCols) {
                    throw MathRuntimeException.createIllegalArgumentException(DIFFERENT_ROWS_LENGTHS_MESSAGE, nCols, subMatrix[i].length);
                }
                System.arraycopy(subMatrix[i], 0, this.data[i + row], column, nCols);
            }
        } else {
            super.setSubMatrix(subMatrix, row, column);
        }
    }

    public double getEntry(int row, int column) throws MatrixIndexException {
        try {
            return this.data[row][column];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(NO_ENTRY_MESSAGE, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    public void setEntry(int row, int column, double value) throws MatrixIndexException {
        try {
            this.data[row][column] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(NO_ENTRY_MESSAGE, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    public void addToEntry(int row, int column, double increment) throws MatrixIndexException {
        try {
            double[] dArray = this.data[row];
            int n = column;
            dArray[n] = dArray[n] + increment;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(NO_ENTRY_MESSAGE, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    public void multiplyEntry(int row, int column, double factor) throws MatrixIndexException {
        try {
            double[] dArray = this.data[row];
            int n = column;
            dArray[n] = dArray[n] * factor;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(NO_ENTRY_MESSAGE, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    public double[] operate(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException(VECTOR_LENGTHS_MISMATCH, v.length, nCols);
        }
        double[] out = new double[nRows];
        for (int row = 0; row < nRows; ++row) {
            double[] dataRow = this.data[row];
            double sum = 0.0;
            for (int i = 0; i < nCols; ++i) {
                sum += dataRow[i] * v[i];
            }
            out[row] = sum;
        }
        return out;
    }

    public double[] preMultiply(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(VECTOR_LENGTHS_MISMATCH, v.length, nRows);
        }
        double[] out = new double[nCols];
        for (int col = 0; col < nCols; ++col) {
            double sum = 0.0;
            for (int i = 0; i < nRows; ++i) {
                sum += this.data[i][col] * v[i];
            }
            out[col] = sum;
        }
        return out;
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor) throws .MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            double[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor) throws .MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            double[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, .MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            double[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, .MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            double[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor) throws .MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                double[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor) throws .MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, .MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                double[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, .MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return visitor.end();
    }

    private double[][] copyOut() {
        int nRows = this.getRowDimension();
        double[][] out = new double[nRows][this.getColumnDimension()];
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
        }
        return out;
    }

    private void copyIn(double[][] in) {
        this.setSubMatrix(in, 0, 0);
    }
}

