/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.ode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.pinot.$internal.org.apache.commons.math.MaxEvaluationsExceededException;
import org.apache.pinot.$internal.org.apache.commons.math.ode.DerivativeException;
import org.apache.pinot.$internal.org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.pinot.$internal.org.apache.commons.math.ode.FirstOrderIntegrator;
import org.apache.pinot.$internal.org.apache.commons.math.ode.IntegratorException;
import org.apache.pinot.$internal.org.apache.commons.math.ode.events.CombinedEventsManager;
import org.apache.pinot.$internal.org.apache.commons.math.ode.events.EventHandler;
import org.apache.pinot.$internal.org.apache.commons.math.ode.events.EventState;
import org.apache.pinot.$internal.org.apache.commons.math.ode.sampling.StepHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegrator
implements FirstOrderIntegrator {
    protected Collection<StepHandler> stepHandlers;
    protected double stepStart;
    protected double stepSize;
    protected CombinedEventsManager eventsHandlersManager;
    private final String name;
    private int maxEvaluations;
    private int evaluations;
    private transient FirstOrderDifferentialEquations equations;

    public AbstractIntegrator(String name) {
        this.name = name;
        this.stepHandlers = new ArrayList<StepHandler>();
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
        this.eventsHandlersManager = new CombinedEventsManager();
        this.setMaxEvaluations(-1);
        this.resetEvaluations();
    }

    protected AbstractIntegrator() {
        this(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(StepHandler handler) {
        this.stepHandlers.add(handler);
    }

    @Override
    public Collection<StepHandler> getStepHandlers() {
        return Collections.unmodifiableCollection(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventHandler(EventHandler function, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.eventsHandlersManager.addEventHandler(function, maxCheckInterval, convergence, maxIterationCount);
    }

    @Override
    public Collection<EventHandler> getEventHandlers() {
        return this.eventsHandlersManager.getEventsHandlers();
    }

    @Override
    public void clearEventHandlers() {
        this.eventsHandlersManager.clearEventsHandlers();
    }

    protected boolean requiresDenseOutput() {
        for (StepHandler handler : this.stepHandlers) {
            if (!handler.requiresDenseOutput()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getCurrentStepStart() {
        return this.stepStart;
    }

    @Override
    public double getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations < 0 ? Integer.MAX_VALUE : maxEvaluations;
    }

    @Override
    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public int getEvaluations() {
        return this.evaluations;
    }

    protected void resetEvaluations() {
        this.evaluations = 0;
    }

    protected void setEquations(FirstOrderDifferentialEquations equations) {
        this.equations = equations;
    }

    public void computeDerivatives(double t, double[] y, double[] yDot) throws DerivativeException {
        if (++this.evaluations > this.maxEvaluations) {
            throw new DerivativeException(new MaxEvaluationsExceededException(this.maxEvaluations));
        }
        this.equations.computeDerivatives(t, y, yDot);
    }

    protected void sanityChecks(FirstOrderDifferentialEquations ode, double t0, double[] y0, double t, double[] y) throws IntegratorException {
        if (ode.getDimension() != y0.length) {
            throw new IntegratorException("dimensions mismatch: ODE problem has dimension {0}, initial state vector has dimension {1}", ode.getDimension(), y0.length);
        }
        if (ode.getDimension() != y.length) {
            throw new IntegratorException("dimensions mismatch: ODE problem has dimension {0}, final state vector has dimension {1}", ode.getDimension(), y.length);
        }
        if (Math.abs(t - t0) <= 1.0E-12 * Math.max(Math.abs(t0), Math.abs(t))) {
            throw new IntegratorException("too small integration interval: length = {0}", Math.abs(t - t0));
        }
    }

    protected CombinedEventsManager addEndTimeChecker(double startTime, double endTime, CombinedEventsManager manager) {
        CombinedEventsManager newManager = new CombinedEventsManager();
        for (EventState state : manager.getEventsStates()) {
            newManager.addEventHandler(state.getEventHandler(), state.getMaxCheckInterval(), state.getConvergence(), state.getMaxIterationCount());
        }
        newManager.addEventHandler(new EndTimeChecker(endTime), Double.POSITIVE_INFINITY, Math.ulp(Math.max(Math.abs(startTime), Math.abs(endTime))), 100);
        return newManager;
    }

    private static class EndTimeChecker
    implements EventHandler {
        private final double endTime;

        public EndTimeChecker(double endTime) {
            this.endTime = endTime;
        }

        public int eventOccurred(double t, double[] y, boolean increasing) {
            return 0;
        }

        public double g(double t, double[] y) {
            return t - this.endTime;
        }

        public void resetState(double t, double[] y) {
        }
    }
}

