/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.optimization.fitting;

import org.apache.pinot.$internal.org.apache.commons.math.FunctionEvaluationException;
import org.apache.pinot.$internal.org.apache.commons.math.MathRuntimeException;
import org.apache.pinot.$internal.org.apache.commons.math.optimization.DifferentiableMultivariateVectorialOptimizer;
import org.apache.pinot.$internal.org.apache.commons.math.optimization.OptimizationException;
import org.apache.pinot.$internal.org.apache.commons.math.optimization.fitting.CurveFitter;
import org.apache.pinot.$internal.org.apache.commons.math.optimization.fitting.HarmonicCoefficientsGuesser;
import org.apache.pinot.$internal.org.apache.commons.math.optimization.fitting.HarmonicFunction;
import org.apache.pinot.$internal.org.apache.commons.math.optimization.fitting.ParametricRealFunction;
import org.apache.pinot.$internal.org.apache.commons.math.optimization.fitting.WeightedObservedPoint;

public class HarmonicFitter {
    private final CurveFitter fitter;
    private double[] parameters;

    public HarmonicFitter(DifferentiableMultivariateVectorialOptimizer optimizer) {
        this.fitter = new CurveFitter(optimizer);
        this.parameters = null;
    }

    public HarmonicFitter(DifferentiableMultivariateVectorialOptimizer optimizer, double[] initialGuess) {
        this.fitter = new CurveFitter(optimizer);
        this.parameters = (double[])initialGuess.clone();
    }

    public void addObservedPoint(double weight, double x, double y) {
        this.fitter.addObservedPoint(weight, x, y);
    }

    public HarmonicFunction fit() throws OptimizationException {
        try {
            if (this.parameters == null) {
                WeightedObservedPoint[] observations = this.fitter.getObservations();
                if (observations.length < 4) {
                    throw new OptimizationException("sample contains {0} observed points, at least {1} are required", observations.length, 4);
                }
                HarmonicCoefficientsGuesser guesser = new HarmonicCoefficientsGuesser(observations);
                guesser.guess();
                this.parameters = new double[]{guesser.getGuessedAmplitude(), guesser.getGuessedPulsation(), guesser.getGuessedPhase()};
            }
            double[] fitted = this.fitter.fit(new ParametricHarmonicFunction(), this.parameters);
            return new HarmonicFunction(fitted[0], fitted[1], fitted[2]);
        }
        catch (FunctionEvaluationException fee) {
            throw MathRuntimeException.createInternalError(fee);
        }
    }

    private static class ParametricHarmonicFunction
    implements ParametricRealFunction {
        private ParametricHarmonicFunction() {
        }

        public double value(double x, double[] parameters) {
            double a = parameters[0];
            double omega = parameters[1];
            double phi = parameters[2];
            return a * Math.cos(omega * x + phi);
        }

        public double[] gradient(double x, double[] parameters) {
            double a = parameters[0];
            double omega = parameters[1];
            double phi = parameters[2];
            double alpha = omega * x + phi;
            double cosAlpha = Math.cos(alpha);
            double sinAlpha = Math.sin(alpha);
            return new double[]{cosAlpha, -a * x * sinAlpha, -a * sinAlpha};
        }
    }
}

