/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.optimization.univariate;

import org.apache.pinot.$internal.org.apache.commons.math.FunctionEvaluationException;
import org.apache.pinot.$internal.org.apache.commons.math.MaxIterationsExceededException;
import org.apache.pinot.$internal.org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.pinot.$internal.org.apache.commons.math.optimization.GoalType;
import org.apache.pinot.$internal.org.apache.commons.math.optimization.univariate.AbstractUnivariateRealOptimizer;

public class BrentOptimizer
extends AbstractUnivariateRealOptimizer {
    private static final double GOLDEN_SECTION = 0.5 * (3.0 - Math.sqrt(5.0));

    public BrentOptimizer() {
        super(100, 1.0E-10);
    }

    public double optimize(UnivariateRealFunction f, GoalType goalType, double min, double max, double startValue) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.optimize(f, goalType, min, max);
    }

    public double optimize(UnivariateRealFunction f, GoalType goalType, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.clearResult();
        return this.localMin(f, goalType, min, max, this.relativeAccuracy, this.absoluteAccuracy);
    }

    private double localMin(UnivariateRealFunction f, GoalType goalType, double a, double b, double eps, double t) throws MaxIterationsExceededException, FunctionEvaluationException {
        double x;
        double v = x = a + GOLDEN_SECTION * (b - a);
        double w = x;
        double e = 0.0;
        double fx = this.computeObjectiveValue(f, x);
        if (goalType == GoalType.MAXIMIZE) {
            fx = -fx;
        }
        double fv = fx;
        double fw = fx;
        for (int count = 0; count < this.maximalIterationCount; ++count) {
            double m = 0.5 * (a + b);
            double tol = eps * Math.abs(x) + t;
            double t2 = 2.0 * tol;
            if (Math.abs(x - m) > t2 - 0.5 * (b - a)) {
                double p = 0.0;
                double q = 0.0;
                double r = 0.0;
                double d = 0.0;
                double u = 0.0;
                if (Math.abs(e) > tol) {
                    r = (x - w) * (fx - fv);
                    q = (x - v) * (fx - fw);
                    p = (x - v) * q - (x - w) * r;
                    if ((q = 2.0 * (q - r)) > 0.0) {
                        p = -p;
                    } else {
                        q = -q;
                    }
                    r = e;
                    e = d;
                }
                if (Math.abs(p) < Math.abs(0.5 * q * r) && p < q * (a - x) && p < q * (b - x)) {
                    d = p / q;
                    u = x + d;
                    if (u - a < t2 || b - u < t2) {
                        d = x < m ? tol : -tol;
                    }
                } else {
                    e = (x < m ? b : a) - x;
                    d = GOLDEN_SECTION * e;
                }
                u = x + (Math.abs(d) > tol ? d : (d > 0.0 ? tol : -tol));
                double fu = this.computeObjectiveValue(f, u);
                if (goalType == GoalType.MAXIMIZE) {
                    fu = -fu;
                }
                if (fu <= fx) {
                    if (u < x) {
                        b = x;
                    } else {
                        a = x;
                    }
                    v = w;
                    fv = fw;
                    w = x;
                    fw = fx;
                    x = u;
                    fx = fu;
                    continue;
                }
                if (u < x) {
                    a = u;
                } else {
                    b = u;
                }
                if (fu <= fw || w == x) {
                    v = w;
                    fv = fw;
                    w = u;
                    fw = fu;
                    continue;
                }
                if (!(fu <= fv) && v != x && v != w) continue;
                v = u;
                fv = fu;
                continue;
            }
            this.setResult(x, goalType == GoalType.MAXIMIZE ? -fx : fx, count);
            return x;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

