/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.random;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;
import org.apache.pinot.$internal.org.apache.commons.math.MathRuntimeException;
import org.apache.pinot.$internal.org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.pinot.$internal.org.apache.commons.math.random.RandomData;
import org.apache.pinot.$internal.org.apache.commons.math.random.RandomGenerator;
import org.apache.pinot.$internal.org.apache.commons.math.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomDataImpl
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private SecureRandom secRand = null;

    public RandomDataImpl() {
    }

    public RandomDataImpl(RandomGenerator rand) {
        this.rand = rand;
    }

    @Override
    public String nextHexString(int len) {
        if (len <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("length must be positive ({0})", len);
        }
        RandomGenerator ran = this.getRan();
        StringBuffer outBuffer = new StringBuffer();
        byte[] randomBytes = new byte[len / 2 + 1];
        ran.nextBytes(randomBytes);
        for (int i = 0; i < randomBytes.length; ++i) {
            Integer c = randomBytes[i];
            String hex = Integer.toHexString(c + 128);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            outBuffer.append(hex);
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextInt(int lower, int upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        double r = this.getRan().nextDouble();
        return (int)(r * (double)upper + (1.0 - r) * (double)lower + r);
    }

    @Override
    public long nextLong(long lower, long upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        double r = this.getRan().nextDouble();
        return (long)(r * (double)upper + (1.0 - r) * (double)lower + r);
    }

    @Override
    public String nextSecureHexString(int len) {
        if (len <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("length must be positive ({0})", len);
        }
        SecureRandom secRan = this.getSecRan();
        MessageDigest alg = null;
        try {
            alg = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw MathRuntimeException.createInternalError(ex);
        }
        alg.reset();
        int numIter = len / 40 + 1;
        StringBuffer outBuffer = new StringBuffer();
        for (int iter = 1; iter < numIter + 1; ++iter) {
            byte[] randomBytes = new byte[40];
            secRan.nextBytes(randomBytes);
            alg.update(randomBytes);
            byte[] hash = alg.digest();
            for (int i = 0; i < hash.length; ++i) {
                Integer c = hash[i];
                String hex = Integer.toHexString(c + 128);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                outBuffer.append(hex);
            }
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextSecureInt(int lower, int upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        SecureRandom sec = this.getSecRan();
        return lower + (int)(sec.nextDouble() * (double)(upper - lower + 1));
    }

    @Override
    public long nextSecureLong(long lower, long upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        SecureRandom sec = this.getSecRan();
        return lower + (long)(sec.nextDouble() * (double)(upper - lower + 1L));
    }

    @Override
    public long nextPoisson(double mean) {
        double y;
        long y2;
        block10: {
            if (mean <= 0.0) {
                throw MathRuntimeException.createIllegalArgumentException("the Poisson mean must be positive ({0})", mean);
            }
            RandomGenerator generator = this.getRan();
            double pivot = 40.0;
            if (mean < 40.0) {
                double p = Math.exp(-mean);
                long n = 0L;
                double r = 1.0;
                double rnd = 1.0;
                while ((double)n < 1000.0 * mean) {
                    rnd = generator.nextDouble();
                    if ((r *= rnd) >= p) {
                        ++n;
                        continue;
                    }
                    return n;
                }
                return n;
            }
            double lambda = Math.floor(mean);
            double lambdaFractional = mean - lambda;
            double logLambda = Math.log(lambda);
            double logLambdaFactorial = MathUtils.factorialLog((int)lambda);
            y2 = lambdaFractional < Double.MIN_VALUE ? 0L : this.nextPoisson(lambdaFractional);
            double delta = Math.sqrt(lambda * Math.log(32.0 * lambda / Math.PI + 1.0));
            double halfDelta = delta / 2.0;
            double twolpd = 2.0 * lambda + delta;
            double a1 = Math.sqrt(Math.PI * twolpd) * Math.exp(0.0 * lambda);
            double a2 = twolpd / delta * Math.exp(-delta * (1.0 + delta) / twolpd);
            double aSum = a1 + a2 + 1.0;
            double p1 = a1 / aSum;
            double p2 = a2 / aSum;
            double c1 = 1.0 / (8.0 * lambda);
            double x = 0.0;
            y = 0.0;
            double v = 0.0;
            boolean a = false;
            double t = 0.0;
            double qr = 0.0;
            double qa = 0.0;
            while (true) {
                double u;
                if ((u = this.nextUniform(0.0, 1.0)) <= p1) {
                    double n = this.nextGaussian(0.0, 1.0);
                    x = n * Math.sqrt(lambda + halfDelta) - 0.5;
                    if (x > delta || x < -lambda) continue;
                    y = x < 0.0 ? Math.floor(x) : Math.ceil(x);
                    double e = this.nextExponential(1.0);
                    v = -e - n * n / 2.0 + c1;
                } else {
                    if (u > p1 + p2) {
                        y = lambda;
                        break block10;
                    }
                    x = delta + twolpd / delta * this.nextExponential(1.0);
                    y = Math.ceil(x);
                    v = -this.nextExponential(1.0) - delta * (x + 1.0) / twolpd;
                }
                a = x < 0.0;
                t = y * (y + 1.0) / (2.0 * lambda);
                if (v < -t && !a) {
                    y = lambda + y;
                    break block10;
                }
                qr = t * ((2.0 * y + 1.0) / (6.0 * lambda) - 1.0);
                qa = qr - t * t / (3.0 * (lambda + (double)a * (y + 1.0)));
                if (v < qa) {
                    y = lambda + y;
                    break block10;
                }
                if (!(v > qr) && v < y * logLambda - MathUtils.factorialLog((int)(y + lambda)) + logLambdaFactorial) break;
            }
            y = lambda + y;
        }
        return y2 + (long)y;
    }

    @Override
    public double nextGaussian(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("standard deviation must be positive ({0})", sigma);
        }
        return sigma * this.getRan().nextGaussian() + mu;
    }

    @Override
    public double nextExponential(double mean) {
        if (mean <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("mean must be positive ({0})", mean);
        }
        RandomGenerator generator = this.getRan();
        double unif = generator.nextDouble();
        while (unif == 0.0) {
            unif = generator.nextDouble();
        }
        return -mean * Math.log(unif);
    }

    @Override
    public double nextUniform(double lower, double upper) {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound ({0}) must be greater than lower bound ({1})", upper, lower);
        }
        RandomGenerator generator = this.getRan();
        double u = generator.nextDouble();
        while (u <= 0.0) {
            u = generator.nextDouble();
        }
        return lower + u * (upper - lower);
    }

    private RandomGenerator getRan() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
            this.rand.setSeed(System.currentTimeMillis());
        }
        return this.rand;
    }

    private SecureRandom getSecRan() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
            this.secRand.setSeed(System.currentTimeMillis());
        }
        return this.secRand;
    }

    public void reSeed(long seed) {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(seed);
    }

    public void reSeedSecure() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long seed) {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(seed);
    }

    public void reSeed() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(System.currentTimeMillis());
    }

    public void setSecureAlgorithm(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.secRand = SecureRandom.getInstance(algorithm, provider);
    }

    @Override
    public int[] nextPermutation(int n, int k) {
        if (k > n) {
            throw MathRuntimeException.createIllegalArgumentException("permutation k ({0}) exceeds n ({1})", k, n);
        }
        if (k == 0) {
            throw MathRuntimeException.createIllegalArgumentException("permutation k ({0}) must be positive", k);
        }
        int[] index = this.getNatural(n);
        this.shuffle(index, n - k);
        int[] result = new int[k];
        for (int i = 0; i < k; ++i) {
            result[i] = index[n - i - 1];
        }
        return result;
    }

    @Override
    public Object[] nextSample(Collection<?> c, int k) {
        int len = c.size();
        if (k > len) {
            throw MathRuntimeException.createIllegalArgumentException("sample size ({0}) exceeds collection size ({1})", new Object[0]);
        }
        if (k <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("sample size must be positive ({0})", k);
        }
        Object[] objects = c.toArray();
        int[] index = this.nextPermutation(len, k);
        Object[] result = new Object[k];
        for (int i = 0; i < k; ++i) {
            result[i] = objects[index[i]];
        }
        return result;
    }

    private void shuffle(int[] list, int end) {
        int target = 0;
        for (int i = list.length - 1; i >= end; --i) {
            target = i == 0 ? 0 : this.nextInt(0, i);
            int temp = list[target];
            list[target] = list[i];
            list[i] = temp;
        }
    }

    private int[] getNatural(int n) {
        int[] natural = new int[n];
        for (int i = 0; i < n; ++i) {
            natural[i] = i;
        }
        return natural;
    }
}

