/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.stat.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.pinot.$internal.org.apache.commons.math.stat.clustering.Cluster;
import org.apache.pinot.$internal.org.apache.commons.math.stat.clustering.Clusterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansPlusPlusClusterer<T extends Clusterable<T>> {
    private final Random random;

    public KMeansPlusPlusClusterer(Random random) {
        this.random = random;
    }

    public List<Cluster<T>> cluster(Collection<T> points, int k, int maxIterations) {
        List<Cluster<T>> clusters = KMeansPlusPlusClusterer.chooseInitialCenters(points, k, this.random);
        KMeansPlusPlusClusterer.assignPointsToClusters(clusters, points);
        int max = maxIterations < 0 ? Integer.MAX_VALUE : maxIterations;
        for (int count = 0; count < max; ++count) {
            boolean clusteringChanged = false;
            ArrayList<Cluster<T>> newClusters = new ArrayList<Cluster<T>>();
            for (Cluster<T> cluster : clusters) {
                Clusterable newCenter = (Clusterable)cluster.getCenter().centroidOf(cluster.getPoints());
                if (!newCenter.equals(cluster.getCenter())) {
                    clusteringChanged = true;
                }
                newClusters.add(new Cluster<Clusterable>(newCenter));
            }
            if (!clusteringChanged) {
                return clusters;
            }
            KMeansPlusPlusClusterer.assignPointsToClusters(newClusters, points);
            clusters = newClusters;
        }
        return clusters;
    }

    private static <T extends Clusterable<T>> void assignPointsToClusters(Collection<Cluster<T>> clusters, Collection<T> points) {
        for (Clusterable p : points) {
            Cluster<Clusterable> cluster = KMeansPlusPlusClusterer.getNearestCluster(clusters, p);
            cluster.addPoint(p);
        }
    }

    private static <T extends Clusterable<T>> List<Cluster<T>> chooseInitialCenters(Collection<T> points, int k, Random random) {
        ArrayList<T> pointSet = new ArrayList<T>(points);
        ArrayList<Cluster<T>> resultSet = new ArrayList<Cluster<T>>();
        Clusterable firstPoint = (Clusterable)pointSet.remove(random.nextInt(pointSet.size()));
        resultSet.add(new Cluster<Clusterable>(firstPoint));
        double[] dx2 = new double[pointSet.size()];
        block0: while (resultSet.size() < k) {
            int sum = 0;
            for (int i = 0; i < pointSet.size(); ++i) {
                Clusterable p = (Clusterable)pointSet.get(i);
                Cluster<Clusterable> nearest = KMeansPlusPlusClusterer.getNearestCluster(resultSet, p);
                double d = p.distanceFrom(nearest.getCenter());
                sum = (int)((double)sum + d * d);
                dx2[i] = sum;
            }
            double r = random.nextDouble() * (double)sum;
            for (int i = 0; i < dx2.length; ++i) {
                if (!(dx2[i] >= r)) continue;
                Clusterable p = (Clusterable)pointSet.remove(i);
                resultSet.add(new Cluster<Clusterable>(p));
                continue block0;
            }
        }
        return resultSet;
    }

    private static <T extends Clusterable<T>> Cluster<T> getNearestCluster(Collection<Cluster<T>> clusters, T point) {
        double minDistance = Double.MAX_VALUE;
        Cluster<T> minCluster = null;
        for (Cluster<T> c : clusters) {
            double distance = point.distanceFrom(c.getCenter());
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minCluster = c;
        }
        return minCluster;
    }
}

