/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.pinot.$internal.org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -370076995648386763L;
    private int n;
    private double value;

    public SumOfLogs() {
        this.value = 0.0;
        this.n = 0;
    }

    public SumOfLogs(SumOfLogs original) {
        SumOfLogs.copy(original, this);
    }

    public void increment(double d) {
        this.value += Math.log(d);
        ++this.n;
    }

    public double getResult() {
        if (this.n > 0) {
            return this.value;
        }
        return Double.NaN;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    public double evaluate(double[] values, int begin, int length) {
        double sumLog = Double.NaN;
        if (this.test(values, begin, length)) {
            sumLog = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sumLog += Math.log(values[i]);
            }
        }
        return sumLog;
    }

    public SumOfLogs copy() {
        SumOfLogs result = new SumOfLogs();
        SumOfLogs.copy(this, result);
        return result;
    }

    public static void copy(SumOfLogs source, SumOfLogs dest) {
        dest.n = source.n;
        dest.value = source.value;
    }
}

