/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.commons.math.stat.regression;

import org.apache.pinot.$internal.org.apache.commons.math.MathRuntimeException;
import org.apache.pinot.$internal.org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.pinot.$internal.org.apache.commons.math.linear.ArrayRealVector;
import org.apache.pinot.$internal.org.apache.commons.math.linear.RealMatrix;
import org.apache.pinot.$internal.org.apache.commons.math.linear.RealVector;
import org.apache.pinot.$internal.org.apache.commons.math.stat.regression.MultipleLinearRegression;

public abstract class AbstractMultipleLinearRegression
implements MultipleLinearRegression {
    protected RealMatrix X;
    protected RealVector Y;

    public void newSampleData(double[] data, int nobs, int nvars) {
        double[] y = new double[nobs];
        double[][] x = new double[nobs][nvars + 1];
        int pointer = 0;
        for (int i = 0; i < nobs; ++i) {
            y[i] = data[pointer++];
            x[i][0] = 1.0;
            for (int j = 1; j < nvars + 1; ++j) {
                x[i][j] = data[pointer++];
            }
        }
        this.X = new Array2DRowRealMatrix(x);
        this.Y = new ArrayRealVector(y);
    }

    protected void newYSampleData(double[] y) {
        this.Y = new ArrayRealVector(y);
    }

    protected void newXSampleData(double[][] x) {
        this.X = new Array2DRowRealMatrix(x);
    }

    protected void validateSampleData(double[][] x, double[] y) {
        if (x == null || y == null || x.length != y.length) {
            throw MathRuntimeException.createIllegalArgumentException("dimension mismatch {0} != {1}", x == null ? 0 : x.length, y == null ? 0 : y.length);
        }
        if (x.length > 0 && x[0].length > x.length) {
            throw MathRuntimeException.createIllegalArgumentException("not enough data ({0} rows) for this many predictors ({1} predictors)", x.length, x[0].length);
        }
    }

    protected void validateCovarianceData(double[][] x, double[][] covariance) {
        if (x.length != covariance.length) {
            throw MathRuntimeException.createIllegalArgumentException("dimension mismatch {0} != {1}", x.length, covariance.length);
        }
        if (covariance.length > 0 && covariance.length != covariance[0].length) {
            throw MathRuntimeException.createIllegalArgumentException("a {0}x{1} matrix was provided instead of a square matrix", covariance.length, covariance[0].length);
        }
    }

    public double[] estimateRegressionParameters() {
        RealVector b = this.calculateBeta();
        return b.getData();
    }

    public double[] estimateResiduals() {
        RealVector b = this.calculateBeta();
        RealVector e = this.Y.subtract(this.X.operate(b));
        return e.getData();
    }

    public double[][] estimateRegressionParametersVariance() {
        return this.calculateBetaVariance().getData();
    }

    public double[] estimateRegressionParametersStandardErrors() {
        double[][] betaVariance = this.estimateRegressionParametersVariance();
        double sigma = this.calculateYVariance();
        int length = betaVariance[0].length;
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Math.sqrt(sigma * betaVariance[i][i]);
        }
        return result;
    }

    public double estimateRegressandVariance() {
        return this.calculateYVariance();
    }

    protected abstract RealVector calculateBeta();

    protected abstract RealMatrix calculateBetaVariance();

    protected abstract double calculateYVariance();

    protected RealVector calculateResiduals() {
        RealVector b = this.calculateBeta();
        return this.Y.subtract(this.X.operate(b));
    }
}

