/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.bloom;

public class BloomFilterUtil {
    private BloomFilterUtil() {
    }

    public static long computeNumBits(long cardinality, double maxFalsePosProbability) {
        return (long)Math.ceil((double)cardinality * Math.log(maxFalsePosProbability) / Math.log(1.0 / Math.pow(2.0, Math.log(2.0))));
    }

    public static int computeNumberOfHashFunctions(long cardinality, long numBits) {
        return (int)Math.max(1.0, (double)Math.round((double)numBits / (double)cardinality * Math.log(2.0)));
    }

    public static double computeMaxFalsePosProbability(long cardinality, int numHashFunction, long numBits) {
        return Math.pow(1.0 - Math.exp(-1.0 * (double)numHashFunction / ((double)numBits / (double)cardinality)), numHashFunction);
    }

    public static double computeMaxFalsePositiveProbabilityForNumBits(long cardinality, long maxNumBits, double defaultMaxFalsePosProbability) {
        long numBitsRequired = BloomFilterUtil.computeNumBits(cardinality, defaultMaxFalsePosProbability);
        if (numBitsRequired <= maxNumBits) {
            return defaultMaxFalsePosProbability;
        }
        int numHashFunction = BloomFilterUtil.computeNumberOfHashFunctions(cardinality, maxNumBits);
        return BloomFilterUtil.computeMaxFalsePosProbability(cardinality, numHashFunction, maxNumBits);
    }
}

