/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockMultiValIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.docvalsets.SingleValueSet;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;

public class DataFetcher {
    private static final ThreadLocal<int[]> THREAD_LOCAL_DICT_IDS = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
    };
    private final Map<String, Dictionary> _dictionaryMap;
    private final Map<String, SingleValueSet> _singleValueSetMap;
    private final Map<String, BlockMultiValIterator> _blockMultiValIteratorMap;
    private final int[] _reusableMVDictIds;

    public DataFetcher(Map<String, DataSource> dataSourceMap) {
        int numColumns = dataSourceMap.size();
        this._dictionaryMap = new HashMap<String, Dictionary>(numColumns);
        this._singleValueSetMap = new HashMap<String, SingleValueSet>(numColumns);
        this._blockMultiValIteratorMap = new HashMap<String, BlockMultiValIterator>(numColumns);
        int maxNumMultiValues = 0;
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            String column = entry.getKey();
            DataSource dataSource = entry.getValue();
            this._dictionaryMap.put(column, dataSource.getDictionary());
            DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
            BlockValSet blockValueSet = dataSource.nextBlock().getBlockValueSet();
            if (dataSourceMetadata.isSingleValue()) {
                this._singleValueSetMap.put(column, (SingleValueSet)blockValueSet);
                continue;
            }
            this._blockMultiValIteratorMap.put(column, (BlockMultiValIterator)blockValueSet.iterator());
            maxNumMultiValues = Math.max(maxNumMultiValues, dataSourceMetadata.getMaxNumMultiValues());
        }
        this._reusableMVDictIds = new int[maxNumMultiValues];
    }

    public void fetchDictIds(String column, int[] inDocIds, int length, int[] outDictIds) {
        this._singleValueSetMap.get(column).getDictionaryIds(inDocIds, 0, length, outDictIds, 0);
    }

    public void fetchIntValues(String column, int[] inDocIds, int length, int[] outValues) {
        Dictionary dictionary = this._dictionaryMap.get(column);
        if (dictionary != null) {
            int[] dictIds = THREAD_LOCAL_DICT_IDS.get();
            this.fetchDictIds(column, inDocIds, length, dictIds);
            dictionary.readIntValues(dictIds, 0, length, outValues, 0);
        } else {
            this._singleValueSetMap.get(column).getIntValues(inDocIds, 0, length, outValues, 0);
        }
    }

    public void fetchLongValues(String column, int[] inDocIds, int length, long[] outValues) {
        Dictionary dictionary = this._dictionaryMap.get(column);
        if (dictionary != null) {
            int[] dictIds = THREAD_LOCAL_DICT_IDS.get();
            this.fetchDictIds(column, inDocIds, length, dictIds);
            dictionary.readLongValues(dictIds, 0, length, outValues, 0);
        } else {
            this._singleValueSetMap.get(column).getLongValues(inDocIds, 0, length, outValues, 0);
        }
    }

    public void fetchFloatValues(String column, int[] inDocIds, int length, float[] outValues) {
        Dictionary dictionary = this._dictionaryMap.get(column);
        if (dictionary != null) {
            int[] dictIds = THREAD_LOCAL_DICT_IDS.get();
            this.fetchDictIds(column, inDocIds, length, dictIds);
            dictionary.readFloatValues(dictIds, 0, length, outValues, 0);
        } else {
            this._singleValueSetMap.get(column).getFloatValues(inDocIds, 0, length, outValues, 0);
        }
    }

    public void fetchDoubleValues(String column, int[] inDocIds, int length, double[] outValues) {
        Dictionary dictionary = this._dictionaryMap.get(column);
        if (dictionary != null) {
            int[] dictIds = THREAD_LOCAL_DICT_IDS.get();
            this.fetchDictIds(column, inDocIds, length, dictIds);
            dictionary.readDoubleValues(dictIds, 0, length, outValues, 0);
        } else {
            this._singleValueSetMap.get(column).getDoubleValues(inDocIds, 0, length, outValues, 0);
        }
    }

    public void fetchStringValues(String column, int[] inDocIds, int length, String[] outValues) {
        Dictionary dictionary = this._dictionaryMap.get(column);
        if (dictionary != null) {
            int[] dictIds = THREAD_LOCAL_DICT_IDS.get();
            this.fetchDictIds(column, inDocIds, length, dictIds);
            dictionary.readStringValues(dictIds, 0, length, outValues, 0);
        } else {
            this._singleValueSetMap.get(column).getStringValues(inDocIds, 0, length, outValues, 0);
        }
    }

    public void fetchBytesValues(String column, int[] inDocIds, int length, byte[][] outValues) {
        Dictionary dictionary = this._dictionaryMap.get(column);
        if (dictionary != null) {
            int[] dictIds = THREAD_LOCAL_DICT_IDS.get();
            this.fetchDictIds(column, inDocIds, length, dictIds);
            dictionary.readBytesValues(dictIds, 0, length, outValues, 0);
        } else {
            this._singleValueSetMap.get(column).getBytesValues(inDocIds, 0, length, outValues, 0);
        }
    }

    public void fetchDictIds(String column, int[] inDocIds, int length, int[][] outDictIds) {
        BlockMultiValIterator blockMultiValIterator = this._blockMultiValIteratorMap.get(column);
        for (int i = 0; i < length; ++i) {
            blockMultiValIterator.skipTo(inDocIds[i]);
            int numMultiValues = blockMultiValIterator.nextIntVal(this._reusableMVDictIds);
            outDictIds[i] = Arrays.copyOfRange(this._reusableMVDictIds, 0, numMultiValues);
        }
    }

    public void fetchIntValues(String column, int[] inDocIds, int length, int[][] outValues) {
        BlockMultiValIterator blockMultiValIterator = this._blockMultiValIteratorMap.get(column);
        for (int i = 0; i < length; ++i) {
            blockMultiValIterator.skipTo(inDocIds[i]);
            int numMultiValues = blockMultiValIterator.nextIntVal(this._reusableMVDictIds);
            outValues[i] = new int[numMultiValues];
            this._dictionaryMap.get(column).readIntValues(this._reusableMVDictIds, 0, numMultiValues, outValues[i], 0);
        }
    }

    public void fetchLongValues(String column, int[] inDocIds, int length, long[][] outValues) {
        BlockMultiValIterator blockMultiValIterator = this._blockMultiValIteratorMap.get(column);
        for (int i = 0; i < length; ++i) {
            blockMultiValIterator.skipTo(inDocIds[i]);
            int numMultiValues = blockMultiValIterator.nextIntVal(this._reusableMVDictIds);
            outValues[i] = new long[numMultiValues];
            this._dictionaryMap.get(column).readLongValues(this._reusableMVDictIds, 0, numMultiValues, outValues[i], 0);
        }
    }

    public void fetchFloatValues(String column, int[] inDocIds, int length, float[][] outValues) {
        BlockMultiValIterator blockMultiValIterator = this._blockMultiValIteratorMap.get(column);
        for (int i = 0; i < length; ++i) {
            blockMultiValIterator.skipTo(inDocIds[i]);
            int numMultiValues = blockMultiValIterator.nextIntVal(this._reusableMVDictIds);
            outValues[i] = new float[numMultiValues];
            this._dictionaryMap.get(column).readFloatValues(this._reusableMVDictIds, 0, numMultiValues, outValues[i], 0);
        }
    }

    public void fetchDoubleValues(String column, int[] inDocIds, int length, double[][] outValues) {
        BlockMultiValIterator blockMultiValIterator = this._blockMultiValIteratorMap.get(column);
        for (int i = 0; i < length; ++i) {
            blockMultiValIterator.skipTo(inDocIds[i]);
            int numMultiValues = blockMultiValIterator.nextIntVal(this._reusableMVDictIds);
            outValues[i] = new double[numMultiValues];
            this._dictionaryMap.get(column).readDoubleValues(this._reusableMVDictIds, 0, numMultiValues, outValues[i], 0);
        }
    }

    public void fetchStringValues(String column, int[] inDocIds, int length, String[][] outValues) {
        BlockMultiValIterator blockMultiValIterator = this._blockMultiValIteratorMap.get(column);
        for (int i = 0; i < length; ++i) {
            blockMultiValIterator.skipTo(inDocIds[i]);
            int numMultiValues = blockMultiValIterator.nextIntVal(this._reusableMVDictIds);
            outValues[i] = new String[numMultiValues];
            this._dictionaryMap.get(column).readStringValues(this._reusableMVDictIds, 0, numMultiValues, outValues[i], 0);
        }
    }

    public void fetchNumValues(String column, int[] inDocIds, int length, int[] outNumValues) {
        BlockMultiValIterator blockMultiValIterator = this._blockMultiValIteratorMap.get(column);
        for (int i = 0; i < length; ++i) {
            blockMultiValIterator.skipTo(inDocIds[i]);
            outNumValues[i] = blockMultiValIterator.nextIntVal(this._reusableMVDictIds);
        }
    }
}

