/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.common;

import java.util.Arrays;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.EqPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.InPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.NEqPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.NotInPredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.RangePredicate;
import org.apache.pinot.$internal.org.apache.pinot.core.common.predicate.RegexpLikePredicate;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;

public abstract class Predicate {
    private final String lhs;
    private final List<String> rhs;
    private final Type type;

    public Predicate(String lhs, Type predicateType, List<String> rhs) {
        this.lhs = lhs;
        this.type = predicateType;
        this.rhs = rhs;
    }

    protected String getLhs() {
        return this.lhs;
    }

    protected List<String> getRhs() {
        return this.rhs;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "Predicate: type: " + (Object)((Object)this.type) + ", left : " + this.lhs + ", right : " + Arrays.toString(this.rhs.toArray(new String[0])) + "\n";
    }

    public static Predicate newPredicate(FilterQueryTree filterQueryTree) {
        assert (filterQueryTree.getChildren() == null || filterQueryTree.getChildren().isEmpty());
        FilterOperator filterType = filterQueryTree.getOperator();
        String column = filterQueryTree.getColumn();
        List<String> value = filterQueryTree.getValue();
        Predicate predicate = null;
        switch (filterType) {
            case EQUALITY: {
                predicate = new EqPredicate(column, value);
                break;
            }
            case RANGE: {
                predicate = new RangePredicate(column, value);
                break;
            }
            case REGEXP_LIKE: {
                predicate = new RegexpLikePredicate(column, value);
                break;
            }
            case NOT: {
                predicate = new NEqPredicate(column, value);
                break;
            }
            case NOT_IN: {
                predicate = new NotInPredicate(column, value);
                break;
            }
            case IN: {
                predicate = new InPredicate(column, value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported filterType:" + filterType);
            }
        }
        return predicate;
    }

    public static enum Type {
        EQ,
        NEQ,
        REGEXP_LIKE,
        RANGE,
        IN,
        NOT_IN;


        public boolean isExclusive() {
            return this == NEQ || this == NOT_IN;
        }
    }
}

