/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.common.datatable;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.common.datatable.DataTableUtils;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.common.utils.StringUtil;

public class DataTableImplV2
implements DataTable {
    private static final int VERSION = 2;
    private static final int HEADER_SIZE = 52;
    private final int _numRows;
    private final int _numColumns;
    private final DataSchema _dataSchema;
    private final int[] _columnOffsets;
    private final int _rowSizeInBytes;
    private final Map<String, Map<Integer, String>> _dictionaryMap;
    private final byte[] _fixedSizeDataBytes;
    private final ByteBuffer _fixedSizeData;
    private final byte[] _variableSizeDataBytes;
    private final ByteBuffer _variableSizeData;
    private final Map<String, String> _metadata;

    public DataTableImplV2(int numRows, @Nonnull DataSchema dataSchema, @Nonnull Map<String, Map<Integer, String>> dictionaryMap, @Nonnull byte[] fixedSizeDataBytes, @Nonnull byte[] variableSizeDataBytes) {
        this._numRows = numRows;
        this._numColumns = dataSchema.size();
        this._dataSchema = dataSchema;
        this._columnOffsets = new int[this._numColumns];
        this._rowSizeInBytes = DataTableUtils.computeColumnOffsets(dataSchema, this._columnOffsets);
        this._dictionaryMap = dictionaryMap;
        this._fixedSizeDataBytes = fixedSizeDataBytes;
        this._fixedSizeData = ByteBuffer.wrap(fixedSizeDataBytes);
        this._variableSizeDataBytes = variableSizeDataBytes;
        this._variableSizeData = ByteBuffer.wrap(variableSizeDataBytes);
        this._metadata = new HashMap<String, String>();
    }

    public DataTableImplV2() {
        this._numRows = 0;
        this._numColumns = 0;
        this._dataSchema = null;
        this._columnOffsets = null;
        this._rowSizeInBytes = 0;
        this._dictionaryMap = null;
        this._fixedSizeDataBytes = null;
        this._fixedSizeData = null;
        this._variableSizeDataBytes = null;
        this._variableSizeData = null;
        this._metadata = new HashMap<String, String>();
    }

    public DataTableImplV2(@Nonnull ByteBuffer byteBuffer) throws IOException {
        this._numRows = byteBuffer.getInt();
        this._numColumns = byteBuffer.getInt();
        int dictionaryMapStart = byteBuffer.getInt();
        int dictionaryMapLength = byteBuffer.getInt();
        int metadataStart = byteBuffer.getInt();
        int metadataLength = byteBuffer.getInt();
        int dataSchemaStart = byteBuffer.getInt();
        int dataSchemaLength = byteBuffer.getInt();
        int fixedSizeDataStart = byteBuffer.getInt();
        int fixedSizeDataLength = byteBuffer.getInt();
        int variableSizeDataStart = byteBuffer.getInt();
        int variableSizeDataLength = byteBuffer.getInt();
        if (dictionaryMapLength != 0) {
            byte[] dictionaryMapBytes = new byte[dictionaryMapLength];
            byteBuffer.position(dictionaryMapStart);
            byteBuffer.get(dictionaryMapBytes);
            this._dictionaryMap = this.deserializeDictionaryMap(dictionaryMapBytes);
        } else {
            this._dictionaryMap = null;
        }
        byte[] metadataBytes = new byte[metadataLength];
        byteBuffer.position(metadataStart);
        byteBuffer.get(metadataBytes);
        this._metadata = this.deserializeMetadata(metadataBytes);
        if (dataSchemaLength != 0) {
            byte[] schemaBytes = new byte[dataSchemaLength];
            byteBuffer.position(dataSchemaStart);
            byteBuffer.get(schemaBytes);
            this._dataSchema = DataSchema.fromBytes(schemaBytes);
            this._columnOffsets = new int[this._dataSchema.size()];
            this._rowSizeInBytes = DataTableUtils.computeColumnOffsets(this._dataSchema, this._columnOffsets);
        } else {
            this._dataSchema = null;
            this._columnOffsets = null;
            this._rowSizeInBytes = 0;
        }
        if (fixedSizeDataLength != 0) {
            this._fixedSizeDataBytes = new byte[fixedSizeDataLength];
            byteBuffer.position(fixedSizeDataStart);
            byteBuffer.get(this._fixedSizeDataBytes);
            this._fixedSizeData = ByteBuffer.wrap(this._fixedSizeDataBytes);
        } else {
            this._fixedSizeDataBytes = null;
            this._fixedSizeData = null;
        }
        if (variableSizeDataLength != 0) {
            this._variableSizeDataBytes = new byte[variableSizeDataLength];
            byteBuffer.position(variableSizeDataStart);
            byteBuffer.get(this._variableSizeDataBytes);
            this._variableSizeData = ByteBuffer.wrap(this._variableSizeDataBytes);
        } else {
            this._variableSizeDataBytes = null;
            this._variableSizeData = null;
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, Map<Integer, String>> deserializeDictionaryMap(byte[] bytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Map<String, String> deserializeMetadata(byte[] bytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String decodeString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        if (length == 0) {
            return "";
        }
        byte[] buffer = new byte[length];
        int numBytesRead = dataInputStream.read(buffer);
        assert (numBytesRead == length);
        return StringUtil.decodeUtf8(buffer);
    }

    @Override
    public void addException(@Nonnull ProcessingException processingException) {
        this._metadata.put("Exception" + processingException.getErrorCode(), processingException.getMessage());
    }

    @Override
    @Nonnull
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(2);
        dataOutputStream.writeInt(this._numRows);
        dataOutputStream.writeInt(this._numColumns);
        int dataOffset = 52;
        dataOutputStream.writeInt(dataOffset);
        byte[] dictionaryMapBytes = null;
        if (this._dictionaryMap != null) {
            dictionaryMapBytes = this.serializeDictionaryMap();
            dataOutputStream.writeInt(dictionaryMapBytes.length);
            dataOffset += dictionaryMapBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        byte[] metadataBytes = this.serializeMetadata();
        dataOutputStream.writeInt(metadataBytes.length);
        dataOutputStream.writeInt(dataOffset += metadataBytes.length);
        byte[] dataSchemaBytes = null;
        if (this._dataSchema != null) {
            dataSchemaBytes = this._dataSchema.toBytes();
            dataOutputStream.writeInt(dataSchemaBytes.length);
            dataOffset += dataSchemaBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.writeInt(this._fixedSizeDataBytes.length);
            dataOffset += this._fixedSizeDataBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.writeInt(this._variableSizeDataBytes.length);
        } else {
            dataOutputStream.writeInt(0);
        }
        if (dictionaryMapBytes != null) {
            dataOutputStream.write(dictionaryMapBytes);
        }
        dataOutputStream.write(metadataBytes);
        if (dataSchemaBytes != null) {
            dataOutputStream.write(dataSchemaBytes);
        }
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.write(this._fixedSizeDataBytes);
        }
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.write(this._variableSizeDataBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] serializeDictionaryMap() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._dictionaryMap.size());
        for (Map.Entry<String, Map<Integer, String>> dictionaryMapEntry : this._dictionaryMap.entrySet()) {
            String columnName = dictionaryMapEntry.getKey();
            Map<Integer, String> dictionary = dictionaryMapEntry.getValue();
            byte[] bytes = StringUtil.encodeUtf8(columnName);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
            dataOutputStream.writeInt(dictionary.size());
            for (Map.Entry<Integer, String> dictionaryEntry : dictionary.entrySet()) {
                dataOutputStream.writeInt(dictionaryEntry.getKey());
                byte[] valueBytes = StringUtil.encodeUtf8(dictionaryEntry.getValue());
                dataOutputStream.writeInt(valueBytes.length);
                dataOutputStream.write(valueBytes);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] serializeMetadata() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._metadata.size());
        for (Map.Entry<String, String> entry : this._metadata.entrySet()) {
            byte[] keyBytes = StringUtil.encodeUtf8(entry.getKey());
            dataOutputStream.writeInt(keyBytes.length);
            dataOutputStream.write(keyBytes);
            byte[] valueBytes = StringUtil.encodeUtf8(entry.getValue());
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    @Nonnull
    public Map<String, String> getMetadata() {
        return this._metadata;
    }

    @Override
    @Nullable
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    @Override
    public int getNumberOfRows() {
        return this._numRows;
    }

    @Override
    public int getInt(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        return this._fixedSizeData.getInt();
    }

    @Override
    public long getLong(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        return this._fixedSizeData.getLong();
    }

    @Override
    public float getFloat(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        return this._fixedSizeData.getFloat();
    }

    @Override
    public double getDouble(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        return this._fixedSizeData.getDouble();
    }

    @Override
    @Nonnull
    public String getString(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        int dictId = this._fixedSizeData.getInt();
        return this._dictionaryMap.get(this._dataSchema.getColumnName(colId)).get(dictId);
    }

    @Override
    @Nonnull
    public <T> T getObject(int rowId, int colId) {
        int size = this.positionCursorInVariableBuffer(rowId, colId);
        int objectTypeValue = this._variableSizeData.getInt();
        ByteBuffer byteBuffer = this._variableSizeData.slice();
        byteBuffer.limit(size);
        return ObjectSerDeUtils.deserialize(byteBuffer, objectTypeValue);
    }

    @Override
    @Nonnull
    public int[] getIntArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this._variableSizeData.getInt();
        }
        return ints;
    }

    @Override
    @Nonnull
    public long[] getLongArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this._variableSizeData.getLong();
        }
        return longs;
    }

    @Override
    @Nonnull
    public float[] getFloatArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this._variableSizeData.getFloat();
        }
        return floats;
    }

    @Override
    @Nonnull
    public double[] getDoubleArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this._variableSizeData.getDouble();
        }
        return doubles;
    }

    @Override
    @Nonnull
    public String[] getStringArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        String[] strings = new String[length];
        Map<Integer, String> dictionary = this._dictionaryMap.get(this._dataSchema.getColumnName(colId));
        for (int i = 0; i < length; ++i) {
            strings[i] = dictionary.get(this._variableSizeData.getInt());
        }
        return strings;
    }

    private int positionCursorInVariableBuffer(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        this._variableSizeData.position(this._fixedSizeData.getInt());
        return this._fixedSizeData.getInt();
    }

    public String toString() {
        if (this._dataSchema == null) {
            return this._metadata.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._dataSchema.toString()).append('\n');
        stringBuilder.append("numRows: ").append(this._numRows).append('\n');
        this._fixedSizeData.position(0);
        for (int rowId = 0; rowId < this._numRows; ++rowId) {
            for (int colId = 0; colId < this._numColumns; ++colId) {
                switch (this._dataSchema.getColumnDataType(colId)) {
                    case INT: {
                        stringBuilder.append(this._fixedSizeData.getInt());
                        break;
                    }
                    case LONG: {
                        stringBuilder.append(this._fixedSizeData.getLong());
                        break;
                    }
                    case FLOAT: {
                        stringBuilder.append(this._fixedSizeData.getFloat());
                        break;
                    }
                    case DOUBLE: {
                        stringBuilder.append(this._fixedSizeData.getDouble());
                        break;
                    }
                    case STRING: {
                        stringBuilder.append(this._fixedSizeData.getInt());
                        break;
                    }
                    default: {
                        stringBuilder.append(String.format("(%s:%s)", this._fixedSizeData.getInt(), this._fixedSizeData.getInt()));
                    }
                }
                stringBuilder.append("\t");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

