/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.aggregator;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import org.apache.pinot.$internal.org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.data.aggregator.ValueAggregator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.common.data.FieldSpec;

public class DistinctCountHLLValueAggregator
implements ValueAggregator<Object, HyperLogLog> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private static final int DEFAULT_LOG2M_BYTE_SIZE = 180;
    private int _maxByteSize;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTHLL;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public HyperLogLog getInitialAggregatedValue(Object rawValue) {
        HyperLogLog initialValue;
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            initialValue = this.deserializeAggregatedValue(bytes);
            this._maxByteSize = Math.max(this._maxByteSize, bytes.length);
        } else {
            initialValue = new HyperLogLog(8);
            initialValue.offer(rawValue);
            this._maxByteSize = Math.max(this._maxByteSize, 180);
        }
        return initialValue;
    }

    @Override
    public HyperLogLog applyRawValue(HyperLogLog value, Object rawValue) {
        if (rawValue instanceof byte[]) {
            try {
                value.addAll(this.deserializeAggregatedValue((byte[])rawValue));
            }
            catch (CardinalityMergeException e) {
                throw new RuntimeException(e);
            }
        } else {
            value.offer(rawValue);
        }
        return value;
    }

    @Override
    public HyperLogLog applyAggregatedValue(HyperLogLog value, HyperLogLog aggregatedValue) {
        try {
            value.addAll(aggregatedValue);
            return value;
        }
        catch (CardinalityMergeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HyperLogLog cloneAggregatedValue(HyperLogLog value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize;
    }

    @Override
    public byte[] serializeAggregatedValue(HyperLogLog value) {
        return ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.serialize(value);
    }

    @Override
    public HyperLogLog deserializeAggregatedValue(byte[] bytes) {
        return ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytes);
    }
}

