/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.function;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.function.FunctionInfo;

public class FunctionRegistry {
    static Map<String, List<FunctionInfo>> _functionInfoMap = new HashMap<String, List<FunctionInfo>>();

    public static FunctionInfo resolve(String functionName, Class<?>[] argumentTypes) {
        List<FunctionInfo> list = _functionInfoMap.get(functionName.toLowerCase());
        FunctionInfo bestMatch = null;
        if (list != null && list.size() > 0) {
            for (FunctionInfo functionInfo : list) {
                if (!functionInfo.isApplicable(argumentTypes)) continue;
                bestMatch = functionInfo;
                break;
            }
        }
        return bestMatch;
    }

    public static void registerStaticFunction(Method method) {
        Preconditions.checkArgument(Modifier.isStatic(method.getModifiers()), "Method needs to be static:" + method);
        ArrayList<FunctionInfo> list = new ArrayList<FunctionInfo>();
        FunctionInfo functionInfo = new FunctionInfo(method, method.getDeclaringClass());
        list.add(functionInfo);
        _functionInfoMap.put(method.getName().toLowerCase(), list);
    }
}

