/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.manager;

import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegment;

public abstract class SegmentDataManager {
    private int _referenceCount = 1;

    @VisibleForTesting
    synchronized int getReferenceCount() {
        return this._referenceCount;
    }

    public synchronized boolean increaseReferenceCount() {
        if (this._referenceCount == 0) {
            return false;
        }
        ++this._referenceCount;
        return true;
    }

    public synchronized boolean decreaseReferenceCount() {
        if (this._referenceCount <= 1) {
            this._referenceCount = 0;
            return true;
        }
        --this._referenceCount;
        return false;
    }

    public abstract String getSegmentName();

    public abstract IndexSegment getSegment();

    public abstract void destroy();
}

