/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.manager.config;

import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.config.InstanceDataManagerConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.utils.CommonConstants;

public class TableDataManagerConfig {
    private static final String TABLE_DATA_MANAGER_TYPE = "dataManagerType";
    private static final String TABLE_DATA_MANAGER_DATA_DIRECTORY = "directory";
    private static final String TABLE_DATA_MANAGER_CONSUMER_DIRECTORY = "consumerDirectory";
    private static final String TABLE_DATA_MANAGER_NAME = "name";
    private final Configuration _tableDataManagerConfig;

    public TableDataManagerConfig(@Nonnull Configuration tableDataManagerConfig) {
        this._tableDataManagerConfig = tableDataManagerConfig;
    }

    public Configuration getConfig() {
        return this._tableDataManagerConfig;
    }

    public String getTableDataManagerType() {
        return this._tableDataManagerConfig.getString(TABLE_DATA_MANAGER_TYPE);
    }

    public String getDataDir() {
        return this._tableDataManagerConfig.getString(TABLE_DATA_MANAGER_DATA_DIRECTORY);
    }

    public String getConsumerDir() {
        return this._tableDataManagerConfig.getString(TABLE_DATA_MANAGER_CONSUMER_DIRECTORY);
    }

    public String getTableName() {
        return this._tableDataManagerConfig.getString(TABLE_DATA_MANAGER_NAME);
    }

    public static TableDataManagerConfig getDefaultHelixTableDataManagerConfig(@Nonnull InstanceDataManagerConfig instanceDataManagerConfig, @Nonnull String tableNameWithType) {
        PropertiesConfiguration defaultConfig = new PropertiesConfiguration();
        defaultConfig.addProperty(TABLE_DATA_MANAGER_NAME, tableNameWithType);
        defaultConfig.addProperty(TABLE_DATA_MANAGER_DATA_DIRECTORY, instanceDataManagerConfig.getInstanceDataDir() + "/" + tableNameWithType);
        defaultConfig.addProperty(TABLE_DATA_MANAGER_CONSUMER_DIRECTORY, instanceDataManagerConfig.getConsumerDir());
        CommonConstants.Helix.TableType tableType = TableNameBuilder.getTableTypeFromTableName(tableNameWithType);
        Preconditions.checkNotNull(tableType);
        defaultConfig.addProperty(TABLE_DATA_MANAGER_TYPE, tableType.name());
        return new TableDataManagerConfig(defaultConfig);
    }

    public void overrideConfigs(@Nonnull TableConfig tableConfig) {
    }
}

