/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.manager.offline;

import java.util.concurrent.Semaphore;
import javax.annotation.Nonnull;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.BaseTableDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.TableDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.config.InstanceDataManagerConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.config.TableDataManagerConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.offline.OfflineTableDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.CommonConstants;

public class TableDataManagerProvider {
    private static Semaphore _segmentBuildSemaphore;

    private TableDataManagerProvider() {
    }

    public static void init(InstanceDataManagerConfig instanceDataManagerConfig) {
        int maxParallelBuilds = instanceDataManagerConfig.getMaxParallelSegmentBuilds();
        if (maxParallelBuilds > 0) {
            _segmentBuildSemaphore = new Semaphore(maxParallelBuilds, true);
        }
    }

    public static TableDataManager getTableDataManager(@Nonnull TableDataManagerConfig tableDataManagerConfig, @Nonnull String instanceId, @Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull ServerMetrics serverMetrics) {
        BaseTableDataManager tableDataManager;
        switch (CommonConstants.Helix.TableType.valueOf(tableDataManagerConfig.getTableDataManagerType())) {
            case OFFLINE: {
                tableDataManager = new OfflineTableDataManager();
                break;
            }
            case REALTIME: {
                tableDataManager = new RealtimeTableDataManager(_segmentBuildSemaphore);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        tableDataManager.init(tableDataManagerConfig, instanceId, propertyStore, serverMetrics);
        return tableDataManager;
    }
}

