/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.$internal.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.TimerService;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.CompoundTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.mutable.MutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.RealtimeSegmentConverter;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConsumerFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamLevelConsumer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.common.config.IndexingConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.CommonConstants;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLRealtimeSegmentDataManager
extends RealtimeSegmentDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HLRealtimeSegmentDataManager.class);
    private static final long ONE_MINUTE_IN_MILLSEC = 60000L;
    private final String tableName;
    private final String segmentName;
    private final Schema schema;
    private final String timeColumnName;
    private final RecordTransformer _recordTransformer;
    private final RealtimeSegmentZKMetadata segmentMetatdaZk;
    private final StreamConsumerFactory _streamConsumerFactory;
    private final StreamLevelConsumer _streamLevelConsumer;
    private final File resourceDir;
    private final File resourceTmpDir;
    private final MutableSegmentImpl realtimeSegment;
    private final String tableStreamName;
    private final StreamConfig _streamConfig;
    private final long start = System.currentTimeMillis();
    private long segmentEndTimeThreshold;
    private AtomicLong lastUpdatedRawDocuments = new AtomicLong(0L);
    private volatile boolean keepIndexing = true;
    private volatile boolean isShuttingDown = false;
    private TimerTask segmentStatusTask;
    private final ServerMetrics serverMetrics;
    private final RealtimeTableDataManager notifier;
    private Thread indexingThread;
    private final String sortedColumn;
    private final List<String> invertedIndexColumns;
    private final List<String> noDictionaryColumns;
    private Logger segmentLogger = LOGGER;
    private final SegmentVersion _segmentVersion;

    public HLRealtimeSegmentDataManager(final RealtimeSegmentZKMetadata realtimeSegmentZKMetadata, TableConfig tableConfig, InstanceZKMetadata instanceMetadata, RealtimeTableDataManager realtimeTableDataManager, final String resourceDataDir, final IndexLoadingConfig indexLoadingConfig, final Schema schema, final ServerMetrics serverMetrics) throws Exception {
        this._segmentVersion = indexLoadingConfig.getSegmentVersion();
        this.schema = schema;
        this._recordTransformer = CompoundTransformer.getDefaultTransformer(schema);
        this.serverMetrics = serverMetrics;
        this.segmentName = realtimeSegmentZKMetadata.getSegmentName();
        this.tableName = tableConfig.getTableName();
        this.timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        List<String> sortedColumns = indexLoadingConfig.getSortedColumns();
        if (sortedColumns.isEmpty()) {
            LOGGER.info("RealtimeDataResourceZKMetadata contains no information about sorted column for segment {}", (Object)this.segmentName);
            this.sortedColumn = null;
        } else {
            String firstSortedColumn = sortedColumns.get(0);
            if (this.schema.hasColumn(firstSortedColumn)) {
                LOGGER.info("Setting sorted column name: {} from RealtimeDataResourceZKMetadata for segment {}", (Object)firstSortedColumn, (Object)this.segmentName);
                this.sortedColumn = firstSortedColumn;
            } else {
                LOGGER.warn("Sorted column name: {} from RealtimeDataResourceZKMetadata is not existed in schema for segment {}.", (Object)firstSortedColumn, (Object)this.segmentName);
                this.sortedColumn = null;
            }
        }
        Set<String> invertedIndexColumns = indexLoadingConfig.getInvertedIndexColumns();
        if (this.sortedColumn != null) {
            invertedIndexColumns.add(this.sortedColumn);
        }
        this.invertedIndexColumns = new ArrayList<String>(invertedIndexColumns);
        this.segmentMetatdaZk = realtimeSegmentZKMetadata;
        this.noDictionaryColumns = new ArrayList<String>(indexLoadingConfig.getNoDictionaryColumns());
        this._streamConfig = new StreamConfig(tableConfig.getIndexingConfig().getStreamConfigs());
        this.segmentLogger = LoggerFactory.getLogger((String)(HLRealtimeSegmentDataManager.class.getName() + "_" + this.segmentName + "_" + this._streamConfig.getTopicName()));
        this.segmentLogger.info("Created segment data manager with Sorted column:{}, invertedIndexColumns:{}", (Object)this.sortedColumn, this.invertedIndexColumns);
        this.segmentEndTimeThreshold = this.start + this._streamConfig.getFlushThresholdTimeMillis();
        this.resourceDir = new File(resourceDataDir);
        this.resourceTmpDir = new File(resourceDataDir, "_tmp");
        if (!this.resourceTmpDir.exists()) {
            this.resourceTmpDir.mkdirs();
        }
        this._streamConsumerFactory = StreamConsumerFactoryProvider.create(this._streamConfig);
        String clientId = HLRealtimeSegmentDataManager.class.getSimpleName() + "-" + this._streamConfig.getTopicName();
        this._streamLevelConsumer = this._streamConsumerFactory.createStreamLevelConsumer(clientId, this.tableName, schema, instanceMetadata, serverMetrics);
        this._streamLevelConsumer.start();
        this.tableStreamName = this.tableName + "_" + this._streamConfig.getTopicName();
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        if (indexingConfig != null && indexingConfig.isAggregateMetrics()) {
            LOGGER.warn("Updating of metrics only supported for LLC consumer, ignoring.");
        }
        this.segmentLogger.info("Started {} stream provider", (Object)this._streamConfig.getType());
        int capacity = this._streamConfig.getFlushThresholdRows();
        RealtimeSegmentConfig realtimeSegmentConfig = new RealtimeSegmentConfig.Builder().setSegmentName(this.segmentName).setStreamName(this._streamConfig.getTopicName()).setSchema(schema).setCapacity(capacity).setAvgNumMultiValues(indexLoadingConfig.getRealtimeAvgMultiValueCount()).setNoDictionaryColumns(indexLoadingConfig.getNoDictionaryColumns()).setInvertedIndexColumns(invertedIndexColumns).setRealtimeSegmentZKMetadata(realtimeSegmentZKMetadata).setOffHeap(indexLoadingConfig.isRealtimeOffheapAllocation()).setMemoryManager(HLRealtimeSegmentDataManager.getMemoryManager(realtimeTableDataManager.getConsumerDir(), this.segmentName, indexLoadingConfig.isRealtimeOffheapAllocation(), indexLoadingConfig.isDirectRealtimeOffheapAllocation(), serverMetrics)).setStatsHistory(realtimeTableDataManager.getStatsHistory()).build();
        this.realtimeSegment = new MutableSegmentImpl(realtimeSegmentConfig);
        this.notifier = realtimeTableDataManager;
        LOGGER.info("Starting consumption on realtime consuming segment {} maxRowCount {} maxEndTime {}", new Object[]{this.segmentName, capacity, new DateTime(this.segmentEndTimeThreshold, DateTimeZone.UTC).toString()});
        this.segmentStatusTask = new TimerTask(){

            @Override
            public void run() {
                HLRealtimeSegmentDataManager.this.computeKeepIndexing();
            }
        };
        this.indexingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block14: {
                    boolean notFull = true;
                    long exceptionSleepMillis = 50L;
                    HLRealtimeSegmentDataManager.this.segmentLogger.info("Starting to collect rows");
                    int numRowsErrored = 0;
                    GenericRow consumedRow = null;
                    do {
                        try {
                            GenericRow transformedRow;
                            consumedRow = GenericRow.createOrReuseRow(consumedRow);
                            consumedRow = HLRealtimeSegmentDataManager.this._streamLevelConsumer.next(consumedRow);
                            if (consumedRow == null || (transformedRow = HLRealtimeSegmentDataManager.this._recordTransformer.transform(consumedRow)) == null) continue;
                            notFull = HLRealtimeSegmentDataManager.this.realtimeSegment.index(transformedRow);
                            exceptionSleepMillis = 50L;
                        }
                        catch (Exception e) {
                            HLRealtimeSegmentDataManager.this.segmentLogger.warn("Caught exception while indexing row, sleeping for {} ms, row contents {}", new Object[]{exceptionSleepMillis, consumedRow, e});
                            ++numRowsErrored;
                            Uninterruptibles.sleepUninterruptibly(exceptionSleepMillis, TimeUnit.MILLISECONDS);
                            exceptionSleepMillis = Math.min(60000L, exceptionSleepMillis * 2L);
                        }
                        catch (Error e) {
                            HLRealtimeSegmentDataManager.this.segmentLogger.error("Caught error in indexing thread", (Throwable)e);
                            throw e;
                        }
                    } while (notFull && HLRealtimeSegmentDataManager.this.keepIndexing && !HLRealtimeSegmentDataManager.this.isShuttingDown);
                    if (HLRealtimeSegmentDataManager.this.isShuttingDown) {
                        HLRealtimeSegmentDataManager.this.segmentLogger.info("Shutting down indexing thread!");
                        return;
                    }
                    try {
                        boolean commitSuccessful;
                        ImmutableSegment segment;
                        TimeUnit timeUnit;
                        long segEndTime;
                        long segStartTime;
                        block13: {
                            if (numRowsErrored > 0) {
                                serverMetrics.addMeteredTableValue(HLRealtimeSegmentDataManager.this.tableStreamName, ServerMeter.ROWS_WITH_ERRORS, numRowsErrored);
                            }
                            HLRealtimeSegmentDataManager.this.segmentLogger.info("Indexing threshold reached, proceeding with index conversion");
                            HLRealtimeSegmentDataManager.this.segmentStatusTask.cancel();
                            HLRealtimeSegmentDataManager.this.updateCurrentDocumentCountMetrics();
                            HLRealtimeSegmentDataManager.this.segmentLogger.info("Indexed {} raw events", (Object)HLRealtimeSegmentDataManager.this.realtimeSegment.getNumDocsIndexed());
                            File tempSegmentFolder = new File(HLRealtimeSegmentDataManager.this.resourceTmpDir, "tmp-" + String.valueOf(System.currentTimeMillis()));
                            RealtimeSegmentConverter converter = new RealtimeSegmentConverter(HLRealtimeSegmentDataManager.this.realtimeSegment, tempSegmentFolder.getAbsolutePath(), schema, realtimeSegmentZKMetadata.getTableName(), HLRealtimeSegmentDataManager.this.timeColumnName, realtimeSegmentZKMetadata.getSegmentName(), HLRealtimeSegmentDataManager.this.sortedColumn, HLRealtimeSegmentDataManager.this.invertedIndexColumns, HLRealtimeSegmentDataManager.this.noDictionaryColumns, null);
                            HLRealtimeSegmentDataManager.this.segmentLogger.info("Trying to build segment");
                            long buildStartTime = System.nanoTime();
                            converter.build(HLRealtimeSegmentDataManager.this._segmentVersion, serverMetrics);
                            long buildEndTime = System.nanoTime();
                            HLRealtimeSegmentDataManager.this.segmentLogger.info("Built segment in {} ms", (Object)TimeUnit.MILLISECONDS.convert(buildEndTime - buildStartTime, TimeUnit.NANOSECONDS));
                            File destDir = new File(resourceDataDir, realtimeSegmentZKMetadata.getSegmentName());
                            FileUtils.deleteQuietly(destDir);
                            FileUtils.moveDirectory(tempSegmentFolder.listFiles()[0], destDir);
                            FileUtils.deleteQuietly(tempSegmentFolder);
                            segStartTime = HLRealtimeSegmentDataManager.this.realtimeSegment.getMinTime();
                            segEndTime = HLRealtimeSegmentDataManager.this.realtimeSegment.getMaxTime();
                            timeUnit = schema.getTimeFieldSpec().getOutgoingGranularitySpec().getTimeType();
                            segment = ImmutableSegmentLoader.load(new File(HLRealtimeSegmentDataManager.this.resourceDir, HLRealtimeSegmentDataManager.this.segmentMetatdaZk.getSegmentName()), indexLoadingConfig);
                            HLRealtimeSegmentDataManager.this.segmentLogger.info("Committing {} offsets", (Object)HLRealtimeSegmentDataManager.this._streamConfig.getType());
                            commitSuccessful = false;
                            try {
                                HLRealtimeSegmentDataManager.this._streamLevelConsumer.commit();
                                commitSuccessful = true;
                                HLRealtimeSegmentDataManager.this._streamLevelConsumer.shutdown();
                                HLRealtimeSegmentDataManager.this.segmentLogger.info("Successfully committed {} offsets, consumer release requested.", (Object)HLRealtimeSegmentDataManager.this._streamConfig.getType());
                            }
                            catch (Throwable e) {
                                HLRealtimeSegmentDataManager.this.segmentLogger.error("FATAL: Exception committing or shutting down consumer commitSuccessful={}", (Object)commitSuccessful, (Object)e);
                                serverMetrics.addMeteredTableValue(HLRealtimeSegmentDataManager.this.tableName, ServerMeter.REALTIME_OFFSET_COMMIT_EXCEPTIONS, 1L);
                                if (commitSuccessful) break block13;
                                HLRealtimeSegmentDataManager.this._streamLevelConsumer.shutdown();
                            }
                        }
                        try {
                            HLRealtimeSegmentDataManager.this.segmentLogger.info("Marking current segment as completed in Helix");
                            RealtimeSegmentZKMetadata metadataToOverwrite = new RealtimeSegmentZKMetadata();
                            metadataToOverwrite.setTableName(realtimeSegmentZKMetadata.getTableName());
                            metadataToOverwrite.setSegmentName(realtimeSegmentZKMetadata.getSegmentName());
                            metadataToOverwrite.setSegmentType(CommonConstants.Segment.SegmentType.OFFLINE);
                            metadataToOverwrite.setStatus(CommonConstants.Segment.Realtime.Status.DONE);
                            metadataToOverwrite.setStartTime(segStartTime);
                            metadataToOverwrite.setEndTime(segEndTime);
                            metadataToOverwrite.setTimeUnit(timeUnit);
                            metadataToOverwrite.setTotalRawDocs(HLRealtimeSegmentDataManager.this.realtimeSegment.getNumDocsIndexed());
                            HLRealtimeSegmentDataManager.this.notifier.notifySegmentCommitted(metadataToOverwrite, segment);
                            HLRealtimeSegmentDataManager.this.segmentLogger.info("Completed write of segment completion to Helix, waiting for controller to assign a new segment");
                        }
                        catch (Exception e) {
                            if (commitSuccessful) {
                                HLRealtimeSegmentDataManager.this.segmentLogger.error("Offsets were committed to Kafka but we were unable to mark this segment as completed in Helix. Manually mark the segment as completed in Helix; restarting this instance will result in data loss.", (Throwable)e);
                                break block14;
                            }
                            HLRealtimeSegmentDataManager.this.segmentLogger.warn("Caught exception while marking segment as completed in Helix. Offsets were not written, restarting the instance should be safe.", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        HLRealtimeSegmentDataManager.this.segmentLogger.error("Caught exception in the realtime indexing thread", (Throwable)e);
                    }
                }
            }
        });
        this.indexingThread.start();
        serverMetrics.addValueToTableGauge(this.tableName, ServerGauge.SEGMENT_COUNT, 1L);
        this.segmentLogger.debug("scheduling keepIndexing timer check");
        TimerService.timer.schedule(this.segmentStatusTask, 60000L, 60000L);
        this.segmentLogger.info("finished scheduling keepIndexing timer check");
    }

    @Override
    public MutableSegment getSegment() {
        return this.realtimeSegment;
    }

    @Override
    public String getSegmentName() {
        return this.segmentName;
    }

    private void computeKeepIndexing() {
        if (this.keepIndexing) {
            this.segmentLogger.debug("Current indexed {} raw events", (Object)this.realtimeSegment.getNumDocsIndexed());
            if (System.currentTimeMillis() >= this.segmentEndTimeThreshold || this.realtimeSegment.getNumDocsIndexed() >= this._streamConfig.getFlushThresholdRows()) {
                if (this.realtimeSegment.getNumDocsIndexed() == 0) {
                    this.segmentLogger.info("no new events coming in, extending the end time by another hour");
                    this.segmentEndTimeThreshold = System.currentTimeMillis() + this._streamConfig.getFlushThresholdTimeMillis();
                    return;
                }
                this.segmentLogger.info("Stopped indexing due to reaching segment limit: {} raw documents indexed, segment is aged {} minutes", (Object)this.realtimeSegment.getNumDocsIndexed(), (Object)((System.currentTimeMillis() - this.start) / 60000L));
                this.keepIndexing = false;
            }
        }
        this.updateCurrentDocumentCountMetrics();
    }

    private void updateCurrentDocumentCountMetrics() {
        int currentRawDocs = this.realtimeSegment.getNumDocsIndexed();
        this.serverMetrics.addValueToTableGauge(this.tableName, ServerGauge.DOCUMENT_COUNT, (long)currentRawDocs - this.lastUpdatedRawDocuments.get());
        this.lastUpdatedRawDocuments.set(currentRawDocs);
    }

    @Override
    public void destroy() {
        LOGGER.info("Trying to shutdown RealtimeSegmentDataManager : {}!", (Object)this.segmentName);
        this.isShuttingDown = true;
        try {
            this._streamLevelConsumer.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("Failed to shutdown stream consumer!", (Throwable)e);
        }
        this.keepIndexing = false;
        this.segmentStatusTask.cancel();
        this.realtimeSegment.destroy();
    }
}

