/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.pinot.$internal.com.yammer.metrics.core.Meter;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.$internal.org.apache.pinot.core.data.manager.realtime.SegmentBuildTimeLeaseExtender;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.CompoundTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.mutable.MutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.RealtimeSegmentConverter;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.MessageBatch;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.PartitionLevelConsumer;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.PartitionLevelStreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.PermanentConsumerException;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConsumerFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamDecoderProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamMessageDecoder;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamMetadataProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.TransientConsumerException;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.config.IndexingConfig;
import org.apache.pinot.common.config.SegmentPartitionConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.data.StarTreeIndexSpec;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.metadata.segment.LLCRealtimeSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.NetUtil;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLRealtimeSegmentDataManager
extends RealtimeSegmentDataManager {
    private static final long TIME_THRESHOLD_FOR_LOG_MINUTES = 1L;
    private static final long TIME_EXTENSION_ON_EMPTY_SEGMENT_HOURS = 1L;
    private static final int MSG_COUNT_THRESHOLD_FOR_LOG = 100000;
    private static final int BUILD_TIME_LEASE_SECONDS = 30;
    private static final int MAX_CONSECUTIVE_ERROR_COUNT = 5;
    private final LLCRealtimeSegmentZKMetadata _segmentZKMetadata;
    private final TableConfig _tableConfig;
    private final RealtimeTableDataManager _realtimeTableDataManager;
    private final StreamMessageDecoder _messageDecoder;
    private final int _segmentMaxRowCount;
    private final String _resourceDataDir;
    private final IndexLoadingConfig _indexLoadingConfig;
    private final Schema _schema;
    private final String _metricKeyName;
    private final ServerMetrics _serverMetrics;
    private final MutableSegmentImpl _realtimeSegment;
    private volatile long _currentOffset;
    private volatile State _state;
    private volatile int _numRowsConsumed = 0;
    private volatile int _numRowsIndexed = 0;
    private volatile int _numRowsErrored = 0;
    private volatile int consecutiveErrorCount = 0;
    private long _startTimeMs = 0L;
    private final String _segmentNameStr;
    private final SegmentVersion _segmentVersion;
    private final SegmentBuildTimeLeaseExtender _leaseExtender;
    private SegmentBuildDescriptor _segmentBuildDescriptor;
    private StreamConsumerFactory _streamConsumerFactory;
    private volatile long _consumeEndTime = 0L;
    private volatile long _finalOffset = -1L;
    private volatile boolean _shouldStop = false;
    private static final int MAX_TIME_FOR_CONSUMING_TO_ONLINE_IN_SECONDS = 31;
    private Thread _consumerThread;
    private final String _streamTopic;
    private final int _streamPartitionId;
    final String _clientId;
    private final LLCSegmentName _segmentName;
    private final RecordTransformer _recordTransformer;
    private PartitionLevelConsumer _partitionLevelConsumer = null;
    private StreamMetadataProvider _streamMetadataProvider = null;
    private final File _resourceTmpDir;
    private final String _tableName;
    private final String _timeColumnName;
    private final List<String> _invertedIndexColumns;
    private final List<String> _noDictionaryColumns;
    private final StarTreeIndexSpec _starTreeIndexSpec;
    private final String _sortedColumn;
    private Logger segmentLogger;
    private final String _tableStreamName;
    private final PinotDataBufferMemoryManager _memoryManager;
    private AtomicLong _lastUpdatedRowsIndexed = new AtomicLong(0L);
    private final String _instanceId;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;
    private final long _consumeStartTime;
    private final long _startOffset;
    private final PartitionLevelStreamConfig _partitionLevelStreamConfig;
    private long _lastLogTime = 0L;
    private int _lastConsumedCount = 0;
    private String _stopReason = null;
    private final Semaphore _segBuildSemaphore;
    private final boolean _isOffHeap;

    private boolean endCriteriaReached() {
        Preconditions.checkState(this._state.shouldConsume(), "Incorrect state %s", (Object)this._state);
        long now = this.now();
        switch (this._state) {
            case INITIAL_CONSUMING: {
                if (now >= this._consumeEndTime) {
                    if (this._realtimeSegment.getNumDocsIndexed() == 0) {
                        this.segmentLogger.info("No events came in, extending time by {} hours", (Object)1L);
                        this._consumeEndTime += TimeUnit.HOURS.toMillis(1L);
                        return false;
                    }
                    this.segmentLogger.info("Stopping consumption due to time limit start={} now={} numRowsConsumed={} numRowsIndexed={}", new Object[]{this._startTimeMs, now, this._numRowsConsumed, this._numRowsIndexed});
                    this._stopReason = "timeLimit";
                    return true;
                }
                if (this._numRowsIndexed >= this._segmentMaxRowCount) {
                    this.segmentLogger.info("Stopping consumption due to row limit nRows={} numRowsIndexed={}, numRowsConsumed={}", new Object[]{this._numRowsIndexed, this._numRowsConsumed, this._segmentMaxRowCount});
                    this._stopReason = "rowLimit";
                    return true;
                }
                return false;
            }
            case CATCHING_UP: {
                this._stopReason = null;
                if (this._currentOffset == this._finalOffset) {
                    this.segmentLogger.info("Caught up to offset={}, state={}", (Object)this._finalOffset, (Object)this._state.toString());
                    return true;
                }
                if (this._currentOffset > this._finalOffset) {
                    this.segmentLogger.error("Offset higher in state={}, current={}, final={}", new Object[]{this._state.toString(), this._currentOffset, this._finalOffset});
                    throw new RuntimeException("Past max offset");
                }
                return false;
            }
            case CONSUMING_TO_ONLINE: {
                if (this._currentOffset == this._finalOffset) {
                    this.segmentLogger.info("Caught up to offset={}, state={}", (Object)this._finalOffset, (Object)this._state.toString());
                    return true;
                }
                if (now >= this._consumeEndTime) {
                    this.segmentLogger.info("Past max time budget: offset={}, state={}", (Object)this._currentOffset, (Object)this._state.toString());
                    return true;
                }
                if (this._currentOffset > this._finalOffset) {
                    this.segmentLogger.error("Offset higher in state={}, current={}, final={}", new Object[]{this._state.toString(), this._currentOffset, this._finalOffset});
                    throw new RuntimeException("Past max offset");
                }
                return false;
            }
        }
        this.segmentLogger.error("Illegal state {}" + this._state.toString());
        throw new RuntimeException("Illegal state to consume");
    }

    private void handleTransientStreamErrors(Exception e) throws Exception {
        ++this.consecutiveErrorCount;
        if (this.consecutiveErrorCount > 5) {
            this.segmentLogger.warn("Stream transient exception when fetching messages, stopping consumption after {} attempts", (Object)this.consecutiveErrorCount, (Object)e);
            throw e;
        }
        this.segmentLogger.warn("Stream transient exception when fetching messages, retrying (count={})", (Object)this.consecutiveErrorCount, (Object)e);
        Uninterruptibles.sleepUninterruptibly(1L, TimeUnit.SECONDS);
        this.makeStreamConsumer("Too many transient errors");
    }

    protected boolean consumeLoop() throws Exception {
        this._numRowsErrored = 0;
        long idlePipeSleepTimeMillis = 100L;
        long maxIdleCountBeforeStatUpdate = 180000L / (100L + (long)this._partitionLevelStreamConfig.getFetchTimeoutMillis());
        long lastUpdatedOffset = this._currentOffset;
        long idleCount = 0L;
        this.removeSegmentFile();
        long _endOffset = Long.MAX_VALUE;
        this.segmentLogger.info("Starting consumption loop start offset {}, finalOffset {}", (Object)this._currentOffset, (Object)this._finalOffset);
        while (!this._shouldStop && !this.endCriteriaReached()) {
            MessageBatch messageBatch;
            try {
                messageBatch = this._partitionLevelConsumer.fetchMessages(this._currentOffset, Long.MAX_VALUE, this._partitionLevelStreamConfig.getFetchTimeoutMillis());
                this.consecutiveErrorCount = 0;
            }
            catch (TimeoutException e) {
                this.handleTransientStreamErrors(e);
                continue;
            }
            catch (TransientConsumerException e) {
                this.handleTransientStreamErrors(e);
                continue;
            }
            catch (PermanentConsumerException e) {
                this.segmentLogger.warn("Permanent exception from stream when fetching messages, stopping consumption", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.handleTransientStreamErrors(e);
                continue;
            }
            this.processStreamEvents(messageBatch, 100L);
            if (this._currentOffset != lastUpdatedOffset) {
                this._serverMetrics.setValueOfTableGauge(this._metricKeyName, ServerGauge.HIGHEST_KAFKA_OFFSET_CONSUMED, this._currentOffset);
                this._serverMetrics.setValueOfTableGauge(this._metricKeyName, ServerGauge.HIGHEST_STREAM_OFFSET_CONSUMED, this._currentOffset);
                this._serverMetrics.setValueOfTableGauge(this._metricKeyName, ServerGauge.LLC_PARTITION_CONSUMING, 1L);
                lastUpdatedOffset = this._currentOffset;
                continue;
            }
            if (++idleCount <= maxIdleCountBeforeStatUpdate) continue;
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, ServerGauge.LLC_PARTITION_CONSUMING, 1L);
            idleCount = 0L;
            this.makeStreamConsumer("Idle for too long");
        }
        if (this._numRowsErrored > 0) {
            this._serverMetrics.addMeteredTableValue(this._metricKeyName, ServerMeter.ROWS_WITH_ERRORS, this._numRowsErrored);
            this._serverMetrics.addMeteredTableValue(this._tableStreamName, ServerMeter.ROWS_WITH_ERRORS, this._numRowsErrored);
        }
        return true;
    }

    private void processStreamEvents(MessageBatch messagesAndOffsets, long idlePipeSleepTimeMillis) {
        Meter realtimeRowsConsumedMeter = null;
        Meter realtimeRowsDroppedMeter = null;
        int indexedMessageCount = 0;
        int streamMessageCount = 0;
        boolean canTakeMore = true;
        GenericRow decodedRow = null;
        for (int index = 0; index < messagesAndOffsets.getMessageCount() && !this._shouldStop && !this.endCriteriaReached(); ++index) {
            if (!canTakeMore) {
                this.segmentLogger.error("Buffer full with {} rows consumed (row limit {}, indexed {})", new Object[]{this._numRowsConsumed, this._numRowsIndexed, this._segmentMaxRowCount});
                throw new RuntimeException("Realtime segment full");
            }
            decodedRow = GenericRow.createOrReuseRow(decodedRow);
            decodedRow = this._messageDecoder.decode(messagesAndOffsets.getMessageAtIndex(index), messagesAndOffsets.getMessageOffsetAtIndex(index), messagesAndOffsets.getMessageLengthAtIndex(index), decodedRow);
            if (decodedRow != null) {
                try {
                    GenericRow transformedRow = this._recordTransformer.transform(decodedRow);
                    if (transformedRow != null) {
                        realtimeRowsConsumedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, ServerMeter.REALTIME_ROWS_CONSUMED, 1L, realtimeRowsConsumedMeter);
                        ++indexedMessageCount;
                    } else {
                        realtimeRowsDroppedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, ServerMeter.INVALID_REALTIME_ROWS_DROPPED, 1L, realtimeRowsDroppedMeter);
                    }
                    canTakeMore = this._realtimeSegment.index(transformedRow);
                }
                catch (Exception e) {
                    this.segmentLogger.debug("Caught exception while transforming the record: {}", (Object)decodedRow, (Object)e);
                    ++this._numRowsErrored;
                }
            } else {
                realtimeRowsDroppedMeter = this._serverMetrics.addMeteredTableValue(this._metricKeyName, ServerMeter.INVALID_REALTIME_ROWS_DROPPED, 1L, realtimeRowsDroppedMeter);
            }
            this._currentOffset = messagesAndOffsets.getNextStreamMessageOffsetAtIndex(index);
            this._numRowsIndexed = this._realtimeSegment.getNumDocsIndexed();
            ++this._numRowsConsumed;
            ++streamMessageCount;
        }
        this.updateCurrentDocumentCountMetrics();
        if (streamMessageCount != 0) {
            this.segmentLogger.debug("Indexed {} messages ({} messages read from stream) current offset {}", new Object[]{indexedMessageCount, streamMessageCount, this._currentOffset});
        } else {
            Uninterruptibles.sleepUninterruptibly(idlePipeSleepTimeMillis, TimeUnit.MILLISECONDS);
        }
    }

    private File makeSegmentDirPath() {
        return new File(this._resourceDataDir, this._segmentZKMetadata.getSegmentName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSegmentForCommit(long buildTimeLeaseMs) {
        try {
            String segTarFile;
            if (this._segmentBuildDescriptor != null && this._segmentBuildDescriptor.getOffset() == this._currentOffset && new File(segTarFile = this._segmentBuildDescriptor.getSegmentTarFilePath()).exists()) {
                return;
            }
            this.removeSegmentFile();
            if (buildTimeLeaseMs <= 0L) {
                buildTimeLeaseMs = this._segBuildSemaphore == null ? (long)SegmentCompletionProtocol.getDefaultMaxSegmentCommitTimeSeconds() * 1000L : 30000L;
            }
            this._leaseExtender.addSegment(this._segmentNameStr, buildTimeLeaseMs, this._currentOffset);
            this._segmentBuildDescriptor = this.buildSegmentInternal(true);
        }
        finally {
            this._leaseExtender.removeSegment(this._segmentNameStr);
        }
    }

    @VisibleForTesting
    protected long getCurrentOffset() {
        return this._currentOffset;
    }

    @VisibleForTesting
    protected SegmentBuildDescriptor getSegmentBuildDescriptor() {
        return this._segmentBuildDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SegmentBuildDescriptor buildSegmentInternal(boolean forCommit) {
        try {
            long startTimeMillis = this.now();
            if (this._segBuildSemaphore != null) {
                this.segmentLogger.info("Waiting to acquire semaphore for building segment");
                this._segBuildSemaphore.acquire();
            }
            this._serverMetrics.addValueToGlobalGauge(ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, 1L);
            long lockAquireTimeMillis = this.now();
            File tempSegmentFolder = new File(this._resourceTmpDir, "tmp-" + this._segmentNameStr + "-" + String.valueOf(this.now()));
            RealtimeSegmentConverter converter = new RealtimeSegmentConverter(this._realtimeSegment, tempSegmentFolder.getAbsolutePath(), this._schema, this._segmentZKMetadata.getTableName(), this._timeColumnName, this._segmentZKMetadata.getSegmentName(), this._sortedColumn, this._invertedIndexColumns, this._noDictionaryColumns, this._starTreeIndexSpec);
            this.segmentLogger.info("Trying to build segment");
            try {
                converter.build(this._segmentVersion, this._serverMetrics);
            }
            catch (Exception e) {
                this.segmentLogger.error("Could not build segment", (Throwable)e);
                FileUtils.deleteQuietly(tempSegmentFolder);
                SegmentBuildDescriptor segmentBuildDescriptor = null;
                if (this._segBuildSemaphore != null) {
                    this._segBuildSemaphore.release();
                }
                this._serverMetrics.addValueToGlobalGauge(ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
                return segmentBuildDescriptor;
            }
            long buildTimeMillis = this.now() - lockAquireTimeMillis;
            long waitTimeMillis = lockAquireTimeMillis - startTimeMillis;
            this.segmentLogger.info("Successfully built segment in {} ms, after lockWaitTime {} ms", (Object)buildTimeMillis, (Object)waitTimeMillis);
            File destDir = this.makeSegmentDirPath();
            FileUtils.deleteQuietly(destDir);
            try {
                FileUtils.moveDirectory(tempSegmentFolder.listFiles()[0], destDir);
                if (forCommit) {
                    TarGzCompressionUtils.createTarGzOfDirectory(destDir.getAbsolutePath());
                }
            }
            catch (IOException e) {
                this.segmentLogger.error("Exception during move/tar segment", (Throwable)e);
                FileUtils.deleteQuietly(tempSegmentFolder);
                SegmentBuildDescriptor segmentBuildDescriptor = null;
                if (this._segBuildSemaphore != null) {
                    this._segBuildSemaphore.release();
                }
                this._serverMetrics.addValueToGlobalGauge(ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
                return segmentBuildDescriptor;
            }
            long segmentSizeBytes = FileUtils.sizeOfDirectory(destDir);
            FileUtils.deleteQuietly(tempSegmentFolder);
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, ServerGauge.LAST_REALTIME_SEGMENT_CREATION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(buildTimeMillis));
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, ServerGauge.LAST_REALTIME_SEGMENT_CREATION_WAIT_TIME_SECONDS, TimeUnit.MILLISECONDS.toSeconds(waitTimeMillis));
            if (forCommit) {
                SegmentBuildDescriptor segmentBuildDescriptor = new SegmentBuildDescriptor(destDir.getAbsolutePath() + ".tar.gz", this._currentOffset, null, buildTimeMillis, waitTimeMillis, segmentSizeBytes);
                return segmentBuildDescriptor;
            }
            SegmentBuildDescriptor segmentBuildDescriptor = new SegmentBuildDescriptor(null, this._currentOffset, destDir.getAbsolutePath(), buildTimeMillis, waitTimeMillis, segmentSizeBytes);
            return segmentBuildDescriptor;
        }
        catch (InterruptedException e) {
            this.segmentLogger.error("Interrupted while waiting for semaphore");
            SegmentBuildDescriptor segmentBuildDescriptor = null;
            return segmentBuildDescriptor;
        }
        finally {
            if (this._segBuildSemaphore != null) {
                this._segBuildSemaphore.release();
            }
            this._serverMetrics.addValueToGlobalGauge(ServerGauge.LLC_SIMULTANEOUS_SEGMENT_BUILDS, -1L);
        }
    }

    private SegmentCompletionProtocol.Response doSplitCommit(SegmentCompletionProtocol.Response prevResponse) {
        SegmentCompletionProtocol.Response commitEndResponse;
        SegmentCompletionProtocol.Response segmentCommitStartResponse;
        File segmentTarFile = new File(this._segmentBuildDescriptor.getSegmentTarFilePath());
        SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
        params.withSegmentName(this._segmentNameStr).withOffset(this._currentOffset).withNumRows(this._numRowsConsumed).withInstanceId(this._instanceId).withBuildTimeMillis(this._segmentBuildDescriptor.getBuildTimeMillis()).withSegmentSizeBytes(this._segmentBuildDescriptor.getSegmentSizeBytes()).withWaitTimeMillis(this._segmentBuildDescriptor.getWaitTimeMillis());
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        if (!(segmentCommitStartResponse = this._protocolHandler.segmentCommitStart(params)).getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_CONTINUE)) {
            this.segmentLogger.warn("CommitStart failed  with response {}", (Object)segmentCommitStartResponse.toJsonString());
            return SegmentCompletionProtocol.RESP_FAILED;
        }
        params = new SegmentCompletionProtocol.Request.Params();
        params.withOffset(this._currentOffset).withSegmentName(this._segmentNameStr).withInstanceId(this._instanceId);
        SegmentCompletionProtocol.Response segmentCommitUploadResponse = this._protocolHandler.segmentCommitUpload(params, segmentTarFile, prevResponse.getControllerVipUrl());
        if (!segmentCommitUploadResponse.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.UPLOAD_SUCCESS)) {
            this.segmentLogger.warn("Segment upload failed  with response {}", (Object)segmentCommitUploadResponse.toJsonString());
            return SegmentCompletionProtocol.RESP_FAILED;
        }
        params = new SegmentCompletionProtocol.Request.Params();
        params.withInstanceId(this._instanceId).withOffset(this._currentOffset).withSegmentName(this._segmentNameStr).withSegmentLocation(segmentCommitUploadResponse.getSegmentLocation()).withNumRows(this._numRowsConsumed).withBuildTimeMillis(this._segmentBuildDescriptor.getBuildTimeMillis()).withSegmentSizeBytes(this._segmentBuildDescriptor.getSegmentSizeBytes()).withWaitTimeMillis(this._segmentBuildDescriptor.getWaitTimeMillis());
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        if (!(commitEndResponse = this._protocolHandler.segmentCommitEnd(params)).getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS)) {
            this.segmentLogger.warn("CommitEnd failed  with response {}", (Object)commitEndResponse.toJsonString());
            return SegmentCompletionProtocol.RESP_FAILED;
        }
        return commitEndResponse;
    }

    protected boolean commitSegment(SegmentCompletionProtocol.Response response) {
        String segTarFileName = this._segmentBuildDescriptor.getSegmentTarFilePath();
        File segTarFile = new File(segTarFileName);
        if (!segTarFile.exists()) {
            throw new RuntimeException("Segment file does not exist:" + segTarFileName);
        }
        SegmentCompletionProtocol.Response returnedResponse = response.isSplitCommit() && this._indexLoadingConfig.isEnableSplitCommit() ? this.doSplitCommit(response) : this.postSegmentCommitMsg();
        if (!returnedResponse.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS)) {
            return false;
        }
        this._realtimeTableDataManager.replaceLLSegment(this._segmentNameStr, this._indexLoadingConfig);
        this.removeSegmentFile();
        return true;
    }

    protected SegmentCompletionProtocol.Response postSegmentCommitMsg() {
        SegmentCompletionProtocol.Response response;
        File segmentTarFile = new File(this._segmentBuildDescriptor.getSegmentTarFilePath());
        SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
        params.withInstanceId(this._instanceId).withOffset(this._currentOffset).withSegmentName(this._segmentNameStr).withNumRows(this._numRowsConsumed).withInstanceId(this._instanceId).withBuildTimeMillis(this._segmentBuildDescriptor.getBuildTimeMillis()).withSegmentSizeBytes(this._segmentBuildDescriptor.getSegmentSizeBytes()).withWaitTimeMillis(this._segmentBuildDescriptor.getWaitTimeMillis());
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        if (!(response = this._protocolHandler.segmentCommit(params, segmentTarFile)).getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS)) {
            this.segmentLogger.warn("Commit failed  with response {}", (Object)response.toJsonString());
        }
        return response;
    }

    protected boolean buildSegmentAndReplace() {
        SegmentBuildDescriptor descriptor = this.buildSegmentInternal(false);
        if (descriptor == null) {
            return false;
        }
        this._realtimeTableDataManager.replaceLLSegment(this._segmentNameStr, this._indexLoadingConfig);
        return true;
    }

    protected void hold() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            this.segmentLogger.warn("Interrupted while holding");
        }
    }

    protected void postStopConsumedMsg(String reason) {
        do {
            SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
            params.withOffset(this._currentOffset).withReason(reason).withSegmentName(this._segmentNameStr).withInstanceId(this._instanceId);
            SegmentCompletionProtocol.Response response = this._protocolHandler.segmentStoppedConsuming(params);
            if (response.getStatus() == SegmentCompletionProtocol.ControllerResponseStatus.PROCESSED) {
                this.segmentLogger.info("Got response {}", (Object)response.toJsonString());
                break;
            }
            Uninterruptibles.sleepUninterruptibly(10L, TimeUnit.SECONDS);
            this.segmentLogger.info("Retrying after response {}", (Object)response.toJsonString());
        } while (!this._shouldStop);
    }

    protected SegmentCompletionProtocol.Response postSegmentConsumedMsg() {
        SegmentCompletionProtocol.Request.Params params = new SegmentCompletionProtocol.Request.Params();
        params.withOffset(this._currentOffset).withSegmentName(this._segmentNameStr).withReason(this._stopReason).withNumRows(this._numRowsConsumed).withInstanceId(this._instanceId);
        if (this._isOffHeap) {
            params.withMemoryUsedBytes(this._memoryManager.getTotalAllocatedBytes());
        }
        return this._protocolHandler.segmentConsumed(params);
    }

    private void removeSegmentFile() {
        if (this._segmentBuildDescriptor != null) {
            this._segmentBuildDescriptor.deleteSegmentFile();
            this._segmentBuildDescriptor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void goOnlineFromConsuming(RealtimeSegmentZKMetadata metadata) throws InterruptedException {
        this._serverMetrics.setValueOfTableGauge(this._metricKeyName, ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        try {
            LLCRealtimeSegmentZKMetadata llcMetadata = (LLCRealtimeSegmentZKMetadata)metadata;
            this.removeSegmentFile();
            this._leaseExtender.removeSegment(this._segmentNameStr);
            long endOffset = llcMetadata.getEndOffset();
            this.segmentLogger.info("State: {}, transitioning from CONSUMING to ONLINE (startOffset: {}, endOffset: {})", new Object[]{this._state.toString(), this._startOffset, endOffset});
            this.stop();
            this.segmentLogger.info("Consumer thread stopped in state {}", (Object)this._state.toString());
            switch (this._state) {
                case COMMITTED: 
                case RETAINED: {
                    this.segmentLogger.info("State {}. Nothing to do", (Object)this._state.toString());
                    return;
                }
                case DISCARDED: 
                case ERROR: {
                    this.segmentLogger.info("State {}. Downloading to replace", (Object)this._state.toString());
                    this.downloadSegmentAndReplace(llcMetadata);
                    return;
                }
                case INITIAL_CONSUMING: 
                case CATCHING_UP: 
                case HOLDING: {
                    if (this._currentOffset > endOffset) {
                        this.segmentLogger.warn("Current offset {} ahead of the offset in zk {}. Downloading to replace", (Object)this._currentOffset, (Object)endOffset);
                        this.downloadSegmentAndReplace(llcMetadata);
                        return;
                    } else if (this._currentOffset == endOffset) {
                        this.segmentLogger.info("Current offset {} matches offset in zk {}. Replacing segment", (Object)this._currentOffset, (Object)endOffset);
                        this.buildSegmentAndReplace();
                        return;
                    } else {
                        this.segmentLogger.info("Attempting to catch up from offset {} to {} ", (Object)this._currentOffset, (Object)endOffset);
                        boolean success = this.catchupToFinalOffset(endOffset, TimeUnit.MILLISECONDS.convert(31L, TimeUnit.SECONDS));
                        if (success) {
                            this.segmentLogger.info("Caught up to offset {}", (Object)this._currentOffset);
                            this.buildSegmentAndReplace();
                            return;
                        } else {
                            this.segmentLogger.info("Could not catch up to offset (current = {}). Downloading to replace", (Object)this._currentOffset);
                            this.downloadSegmentAndReplace(llcMetadata);
                            return;
                        }
                    }
                }
                default: {
                    this.segmentLogger.info("Downloading to replace segment while in state {}", (Object)this._state.toString());
                    this.downloadSegmentAndReplace(llcMetadata);
                    return;
                }
            }
        }
        catch (Exception e) {
            Utils.rethrowException(e);
            return;
        }
        finally {
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
    }

    protected void downloadSegmentAndReplace(LLCRealtimeSegmentZKMetadata metadata) {
        this._realtimeTableDataManager.downloadAndReplaceSegment(this._segmentNameStr, metadata, this._indexLoadingConfig);
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean catchupToFinalOffset(long endOffset, long timeoutMs) {
        this._finalOffset = endOffset;
        this._consumeEndTime = this.now() + timeoutMs;
        this._state = State.CONSUMING_TO_ONLINE;
        this._shouldStop = false;
        try {
            this.consumeLoop();
        }
        catch (Exception e) {
            this.segmentLogger.warn("Exception when catching up to final offset", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this._serverMetrics.setValueOfTableGauge(this._metricKeyName, ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
        if (this._currentOffset != endOffset) {
            this.segmentLogger.error("Could not consume up to {} (current offset {})", (Object)endOffset, (Object)this._currentOffset);
            return false;
        }
        return true;
    }

    @Override
    public void destroy() {
        try {
            this.stop();
        }
        catch (InterruptedException e) {
            this.segmentLogger.error("Could not stop consumer thread");
        }
        this._realtimeSegment.destroy();
        try {
            this._partitionLevelConsumer.close();
        }
        catch (Exception e) {
            this.segmentLogger.warn("Could not close stream consumer", (Throwable)e);
        }
        try {
            this._streamMetadataProvider.close();
        }
        catch (Exception e) {
            this.segmentLogger.warn("Could not close stream metadata provider", (Throwable)e);
        }
    }

    protected void start() {
        this._consumerThread = new Thread((Runnable)new PartitionConsumer(), this._segmentNameStr);
        this.segmentLogger.info("Created new consumer thread {} for {}", (Object)this._consumerThread, (Object)this.toString());
        this._consumerThread.start();
    }

    public void stop() throws InterruptedException {
        this._shouldStop = true;
        if (Thread.currentThread() != this._consumerThread) {
            Uninterruptibles.joinUninterruptibly(this._consumerThread, 10L, TimeUnit.MINUTES);
            if (this._consumerThread.isAlive()) {
                this.segmentLogger.warn("Failed to stop consumer thread within 10 minutes");
            }
        }
    }

    public LLRealtimeSegmentDataManager(RealtimeSegmentZKMetadata segmentZKMetadata, TableConfig tableConfig, InstanceZKMetadata instanceZKMetadata, RealtimeTableDataManager realtimeTableDataManager, String resourceDataDir, IndexLoadingConfig indexLoadingConfig, Schema schema, ServerMetrics serverMetrics) throws Exception {
        long now;
        this._segBuildSemaphore = realtimeTableDataManager.getSegmentBuildSemaphore();
        this._segmentZKMetadata = (LLCRealtimeSegmentZKMetadata)segmentZKMetadata;
        this._tableConfig = tableConfig;
        this._realtimeTableDataManager = realtimeTableDataManager;
        this._resourceDataDir = resourceDataDir;
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._serverMetrics = serverMetrics;
        this._segmentVersion = indexLoadingConfig.getSegmentVersion();
        this._instanceId = this._realtimeTableDataManager.getServerInstance();
        this._leaseExtender = SegmentBuildTimeLeaseExtender.getLeaseExtender(this._instanceId);
        this._protocolHandler = new ServerSegmentCompletionProtocolHandler(this._serverMetrics);
        IndexingConfig indexingConfig = this._tableConfig.getIndexingConfig();
        this._partitionLevelStreamConfig = new PartitionLevelStreamConfig(indexingConfig.getStreamConfigs());
        this._streamConsumerFactory = StreamConsumerFactoryProvider.create(this._partitionLevelStreamConfig);
        this._streamTopic = this._partitionLevelStreamConfig.getTopicName();
        this._segmentNameStr = this._segmentZKMetadata.getSegmentName();
        this._segmentName = new LLCSegmentName(this._segmentNameStr);
        this._streamPartitionId = this._segmentName.getPartitionId();
        this._tableName = this._tableConfig.getTableName();
        this._timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        this._metricKeyName = this._tableName + "-" + this._streamTopic + "-" + this._streamPartitionId;
        this.segmentLogger = LoggerFactory.getLogger((String)(LLRealtimeSegmentDataManager.class.getName() + "_" + this._segmentNameStr));
        this._tableStreamName = this._tableName + "_" + this._streamTopic;
        this._memoryManager = LLRealtimeSegmentDataManager.getMemoryManager(realtimeTableDataManager.getConsumerDir(), this._segmentNameStr, indexLoadingConfig.isRealtimeOffheapAllocation(), indexLoadingConfig.isDirectRealtimeOffheapAllocation(), serverMetrics);
        List<String> sortedColumns = indexLoadingConfig.getSortedColumns();
        if (sortedColumns.isEmpty()) {
            this.segmentLogger.info("RealtimeDataResourceZKMetadata contains no information about sorted column for segment {}", (Object)this._segmentName);
            this._sortedColumn = null;
        } else {
            String firstSortedColumn = sortedColumns.get(0);
            if (this._schema.hasColumn(firstSortedColumn)) {
                this.segmentLogger.info("Setting sorted column name: {} from RealtimeDataResourceZKMetadata for segment {}", (Object)firstSortedColumn, (Object)this._segmentName);
                this._sortedColumn = firstSortedColumn;
            } else {
                this.segmentLogger.warn("Sorted column name: {} from RealtimeDataResourceZKMetadata is not existed in schema for segment {}.", (Object)firstSortedColumn, (Object)this._segmentName);
                this._sortedColumn = null;
            }
        }
        Set<String> invertedIndexColumns = indexLoadingConfig.getInvertedIndexColumns();
        if (this._sortedColumn != null) {
            invertedIndexColumns.add(this._sortedColumn);
        }
        this._invertedIndexColumns = new ArrayList<String>(invertedIndexColumns);
        this._noDictionaryColumns = new ArrayList<String>(indexLoadingConfig.getNoDictionaryColumns());
        this._starTreeIndexSpec = indexingConfig.getStarTreeIndexSpec();
        int segmentMaxRowCount = this._partitionLevelStreamConfig.getFlushThresholdRows();
        if (0 < segmentZKMetadata.getSizeThresholdToFlushSegment()) {
            segmentMaxRowCount = segmentZKMetadata.getSizeThresholdToFlushSegment();
        }
        this._segmentMaxRowCount = segmentMaxRowCount;
        this._isOffHeap = indexLoadingConfig.isRealtimeOffheapAllocation();
        RealtimeSegmentConfig.Builder realtimeSegmentConfigBuilder = new RealtimeSegmentConfig.Builder().setSegmentName(this._segmentNameStr).setStreamName(this._streamTopic).setSchema(schema).setCapacity(this._segmentMaxRowCount).setAvgNumMultiValues(indexLoadingConfig.getRealtimeAvgMultiValueCount()).setNoDictionaryColumns(indexLoadingConfig.getNoDictionaryColumns()).setInvertedIndexColumns(invertedIndexColumns).setRealtimeSegmentZKMetadata(segmentZKMetadata).setOffHeap(this._isOffHeap).setMemoryManager(this._memoryManager).setStatsHistory(realtimeTableDataManager.getStatsHistory()).setAggregateMetrics(indexingConfig.isAggregateMetrics());
        this._messageDecoder = StreamDecoderProvider.create(this._partitionLevelStreamConfig, this._schema);
        this._clientId = this._streamPartitionId + "-" + NetUtil.getHostnameOrAddress();
        this._recordTransformer = CompoundTransformer.getDefaultTransformer(schema);
        this.makeStreamConsumer("Starting");
        this.makeStreamMetadataProvider("Starting");
        SegmentPartitionConfig segmentPartitionConfig = indexingConfig.getSegmentPartitionConfig();
        if (segmentPartitionConfig != null) {
            try {
                int nPartitions = this._streamMetadataProvider.fetchPartitionCount(5000L);
                segmentPartitionConfig.setNumPartitions(nPartitions);
                realtimeSegmentConfigBuilder.setSegmentPartitionConfig(segmentPartitionConfig);
            }
            catch (Exception e) {
                this.segmentLogger.warn("Couldn't get number of partitions in 5s, not using partition config {}", (Object)e.getMessage());
                this.makeStreamMetadataProvider("Timeout getting number of partitions");
            }
        }
        this._realtimeSegment = new MutableSegmentImpl(realtimeSegmentConfigBuilder.build());
        this._currentOffset = this._startOffset = this._segmentZKMetadata.getStartOffset();
        this._resourceTmpDir = new File(resourceDataDir, "_tmp");
        if (!this._resourceTmpDir.exists()) {
            this._resourceTmpDir.mkdirs();
        }
        this._state = State.INITIAL_CONSUMING;
        this._consumeStartTime = now = this.now();
        this._consumeEndTime = now + this._partitionLevelStreamConfig.getFlushThresholdTimeMillis();
        this.segmentLogger.info("Starting consumption on realtime consuming segment {} maxRowCount {} maxEndTime {}", new Object[]{this._segmentName, this._segmentMaxRowCount, new DateTime(this._consumeEndTime, DateTimeZone.UTC).toString()});
        this.start();
    }

    private void makeStreamConsumer(String reason) {
        if (this._partitionLevelConsumer != null) {
            try {
                this._partitionLevelConsumer.close();
            }
            catch (Exception e) {
                this.segmentLogger.warn("Could not close stream consumer");
            }
        }
        this.segmentLogger.info("Creating new stream consumer, reason: {}", (Object)reason);
        this._partitionLevelConsumer = this._streamConsumerFactory.createPartitionLevelConsumer(this._clientId, this._streamPartitionId);
    }

    private void makeStreamMetadataProvider(String reason) {
        if (this._streamMetadataProvider != null) {
            try {
                this._streamMetadataProvider.close();
            }
            catch (Exception e) {
                this.segmentLogger.warn("Could not close stream metadata provider");
            }
        }
        this.segmentLogger.info("Creating new stream metadata provider, reason: {}", (Object)reason);
        this._streamMetadataProvider = this._streamConsumerFactory.createPartitionMetadataProvider(this._clientId, this._streamPartitionId);
    }

    private void updateCurrentDocumentCountMetrics() {
        long prevTime;
        long rowsIndexed = (long)this._numRowsIndexed - this._lastUpdatedRowsIndexed.get();
        this._serverMetrics.addValueToTableGauge(this._tableName, ServerGauge.DOCUMENT_COUNT, rowsIndexed);
        this._lastUpdatedRowsIndexed.set(this._numRowsIndexed);
        long now = this.now();
        int rowsConsumed = this._numRowsConsumed - this._lastConsumedCount;
        long l = prevTime = this._lastConsumedCount == 0 ? this._consumeStartTime : this._lastLogTime;
        if (now - prevTime > TimeUnit.MINUTES.toMillis(1L) || rowsConsumed >= 100000) {
            this.segmentLogger.info("Consumed {} events from (rate:{}/s), currentOffset={}, numRowsConsumedSoFar={}, numRowsIndexedSoFar={}", new Object[]{rowsConsumed, Float.valueOf((float)rowsConsumed * 1000.0f / (float)(now - prevTime)), this._currentOffset, this._numRowsConsumed, this._numRowsIndexed});
            this._lastConsumedCount = this._numRowsConsumed;
            this._lastLogTime = now;
        }
    }

    @Override
    public MutableSegment getSegment() {
        return this._realtimeSegment;
    }

    @Override
    public String getSegmentName() {
        return this._segmentNameStr;
    }

    public class PartitionConsumer
    implements Runnable {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long initialConsumptionEnd = 0L;
            long lastCatchUpStart = 0L;
            long catchUpTimeMillis = 0L;
            LLRealtimeSegmentDataManager.this._startTimeMs = LLRealtimeSegmentDataManager.this.now();
            try {
                block10: while (!LLRealtimeSegmentDataManager.this._state.isFinal()) {
                    if (LLRealtimeSegmentDataManager.this._state.shouldConsume()) {
                        LLRealtimeSegmentDataManager.this.consumeLoop();
                    }
                    LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, ServerGauge.LLC_PARTITION_CONSUMING, 0L);
                    if (!LLRealtimeSegmentDataManager.this._shouldStop) {
                        if (LLRealtimeSegmentDataManager.this._state == State.INITIAL_CONSUMING) {
                            initialConsumptionEnd = LLRealtimeSegmentDataManager.this.now();
                            LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, ServerGauge.LAST_REALTIME_SEGMENT_INITIAL_CONSUMPTION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(initialConsumptionEnd - LLRealtimeSegmentDataManager.this._startTimeMs));
                        } else if (LLRealtimeSegmentDataManager.this._state == State.CATCHING_UP) {
                            LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, ServerGauge.LAST_REALTIME_SEGMENT_CATCHUP_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(catchUpTimeMillis += LLRealtimeSegmentDataManager.this.now() - lastCatchUpStart));
                        }
                        LLRealtimeSegmentDataManager.this._state = State.HOLDING;
                        SegmentCompletionProtocol.Response response = LLRealtimeSegmentDataManager.this.postSegmentConsumedMsg();
                        SegmentCompletionProtocol.ControllerResponseStatus status = response.getStatus();
                        long rspOffset = response.getOffset();
                        switch (status) {
                            case NOT_LEADER: {
                                LLRealtimeSegmentDataManager.this.segmentLogger.warn("Got not leader response");
                                LLRealtimeSegmentDataManager.this.hold();
                                continue block10;
                            }
                            case CATCH_UP: {
                                if (rspOffset <= LLRealtimeSegmentDataManager.this._currentOffset) {
                                    LLRealtimeSegmentDataManager.this.segmentLogger.error("Invalid catchup offset {} in controller response, current offset {}", (Object)rspOffset, (Object)LLRealtimeSegmentDataManager.this._currentOffset);
                                    LLRealtimeSegmentDataManager.this.hold();
                                    continue block10;
                                }
                                LLRealtimeSegmentDataManager.this._state = State.CATCHING_UP;
                                LLRealtimeSegmentDataManager.this._finalOffset = rspOffset;
                                lastCatchUpStart = LLRealtimeSegmentDataManager.this.now();
                                continue block10;
                            }
                            case HOLD: {
                                LLRealtimeSegmentDataManager.this.hold();
                                continue block10;
                            }
                            case DISCARD: {
                                LLRealtimeSegmentDataManager.this._state = State.DISCARDED;
                                continue block10;
                            }
                            case KEEP: {
                                LLRealtimeSegmentDataManager.this._state = State.RETAINING;
                                boolean success = LLRealtimeSegmentDataManager.this.buildSegmentAndReplace();
                                if (success) {
                                    LLRealtimeSegmentDataManager.this._state = State.RETAINED;
                                    continue block10;
                                }
                                LLRealtimeSegmentDataManager.this._state = State.ERROR;
                                continue block10;
                            }
                            case COMMIT: {
                                LLRealtimeSegmentDataManager.this._state = State.COMMITTING;
                                long buildTimeSeconds = response.getBuildTimeSeconds();
                                LLRealtimeSegmentDataManager.this.buildSegmentForCommit(buildTimeSeconds * 1000L);
                                if (LLRealtimeSegmentDataManager.this._segmentBuildDescriptor == null) {
                                    LLRealtimeSegmentDataManager.this._state = State.ERROR;
                                    continue block10;
                                }
                                boolean success = LLRealtimeSegmentDataManager.this.commitSegment(response);
                                if (success) {
                                    LLRealtimeSegmentDataManager.this._state = State.COMMITTED;
                                    continue block10;
                                }
                                LLRealtimeSegmentDataManager.this._state = State.HOLDING;
                                LLRealtimeSegmentDataManager.this.segmentLogger.info("Could not commit segment. Retrying after hold");
                                LLRealtimeSegmentDataManager.this.hold();
                                continue block10;
                            }
                        }
                        LLRealtimeSegmentDataManager.this.segmentLogger.error("Holding after response from Controller: {}", (Object)response.toJsonString());
                        LLRealtimeSegmentDataManager.this.hold();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LLRealtimeSegmentDataManager.this.segmentLogger.error("Exception while in work", (Throwable)e);
                LLRealtimeSegmentDataManager.this.postStopConsumedMsg(e.getClass().getName());
                LLRealtimeSegmentDataManager.this._state = State.ERROR;
                LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, ServerGauge.LLC_PARTITION_CONSUMING, 0L);
                return;
            }
            LLRealtimeSegmentDataManager.this.removeSegmentFile();
            if (initialConsumptionEnd != 0L) {
                LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, ServerGauge.LAST_REALTIME_SEGMENT_COMPLETION_DURATION_SECONDS, TimeUnit.MILLISECONDS.toSeconds(LLRealtimeSegmentDataManager.this.now() - initialConsumptionEnd));
            }
            LLRealtimeSegmentDataManager.this._serverMetrics.setValueOfTableGauge(LLRealtimeSegmentDataManager.this._metricKeyName, ServerGauge.LLC_PARTITION_CONSUMING, 0L);
        }
    }

    protected class SegmentBuildDescriptor {
        final String _segmentTarFilePath;
        final long _offset;
        final long _waitTimeMillis;
        final long _buildTimeMillis;
        final String _segmentDirPath;
        final long _segmentSizeBytes;

        SegmentBuildDescriptor(String segmentTarFilePath, long offset, String segmentDirPath, long buildTimeMillis, long waitTimeMillis, long segmentSizeBytes) {
            this._segmentTarFilePath = segmentTarFilePath;
            this._offset = offset;
            this._buildTimeMillis = buildTimeMillis;
            this._waitTimeMillis = waitTimeMillis;
            this._segmentDirPath = segmentDirPath;
            this._segmentSizeBytes = segmentSizeBytes;
        }

        public long getOffset() {
            return this._offset;
        }

        public long getBuildTimeMillis() {
            return this._buildTimeMillis;
        }

        public long getWaitTimeMillis() {
            return this._waitTimeMillis;
        }

        public String getSegmentTarFilePath() {
            return this._segmentTarFilePath;
        }

        public long getSegmentSizeBytes() {
            return this._segmentSizeBytes;
        }

        public void deleteSegmentFile() {
            if (this._segmentTarFilePath != null) {
                FileUtils.deleteQuietly(new File(this._segmentTarFilePath));
            }
        }
    }

    protected static enum State {
        INITIAL_CONSUMING,
        CATCHING_UP,
        HOLDING,
        CONSUMING_TO_ONLINE,
        RETAINING,
        COMMITTING,
        DISCARDED,
        RETAINED,
        COMMITTED,
        ERROR;


        public boolean shouldConsume() {
            return this.equals((Object)INITIAL_CONSUMING) || this.equals((Object)CATCHING_UP) || this.equals((Object)CONSUMING_TO_ONLINE);
        }

        public boolean isFinal() {
            return this.equals((Object)ERROR) || this.equals((Object)COMMITTED) || this.equals((Object)RETAINED) || this.equals((Object)DISCARDED);
        }
    }
}

