/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.partition;

import kafka.producer.ByteArrayPartitioner;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunction;

public class ByteArrayPartitionFunction
implements PartitionFunction {
    private static final String NAME = "ByteArray";
    private final int _numPartitions;
    public ByteArrayPartitioner _byteArrayPartitioner;

    public ByteArrayPartitionFunction(int numPartitions) {
        Preconditions.checkArgument(numPartitions > 0, "Number of partitions must be > 0, specified", numPartitions);
        this._numPartitions = numPartitions;
        this._byteArrayPartitioner = new ByteArrayPartitioner(null);
    }

    @Override
    public int getPartition(Object valueIn) {
        return this._byteArrayPartitioner.partition((Object)valueIn.toString().getBytes(), this._numPartitions);
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public String toString() {
        return NAME;
    }
}

