/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.partition;

import org.apache.kafka.common.utils.Utils;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.common.utils.StringUtil;

public class MurmurPartitionFunction
implements PartitionFunction {
    private static final String NAME = "Murmur";
    private final int _numPartitions;

    public MurmurPartitionFunction(int numPartitions) {
        Preconditions.checkArgument(numPartitions > 0, "Number of partitions must be > 0, specified", numPartitions);
        this._numPartitions = numPartitions;
    }

    @Override
    public int getPartition(Object valueIn) {
        String value = valueIn instanceof String ? (String)valueIn : valueIn.toString();
        return (Utils.murmur2((byte[])StringUtil.encodeUtf8(value)) & Integer.MAX_VALUE) % this._numPartitions;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public String toString() {
        return NAME;
    }
}

