/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pinot.$internal.org.apache.commons.csv.CSVFormat;
import org.apache.pinot.$internal.org.apache.commons.csv.CSVParser;
import org.apache.pinot.$internal.org.apache.commons.csv.CSVRecord;
import org.apache.pinot.$internal.org.apache.commons.lang.StringUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.CSVRecordReaderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReaderUtils;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;

public class CSVRecordReader
implements RecordReader {
    private final File _dataFile;
    private final Schema _schema;
    private final CSVFormat _format;
    private final char _multiValueDelimiter;
    private CSVParser _parser;
    private Iterator<CSVRecord> _iterator;

    public CSVRecordReader(File dataFile, Schema schema, CSVRecordReaderConfig config) throws IOException {
        this._dataFile = dataFile;
        this._schema = schema;
        if (config == null) {
            this._format = CSVFormat.DEFAULT.withDelimiter(',').withHeader(new String[0]);
            this._multiValueDelimiter = (char)59;
        } else {
            CSVFormat format;
            String formatString = config.getFileFormat();
            if (formatString == null) {
                format = CSVFormat.DEFAULT;
            } else {
                switch (formatString.toUpperCase()) {
                    case "EXCEL": {
                        format = CSVFormat.EXCEL;
                        break;
                    }
                    case "MYSQL": {
                        format = CSVFormat.MYSQL;
                        break;
                    }
                    case "RFC4180": {
                        format = CSVFormat.RFC4180;
                        break;
                    }
                    case "TDF": {
                        format = CSVFormat.TDF;
                        break;
                    }
                    default: {
                        format = CSVFormat.DEFAULT;
                    }
                }
            }
            char delimiter = config.getDelimiter();
            format = format.withDelimiter(delimiter);
            String csvHeader = config.getHeader();
            format = csvHeader == null ? format.withHeader(new String[0]) : format.withHeader(StringUtils.split(csvHeader, delimiter));
            this._format = format;
            this._multiValueDelimiter = config.getMultiValueDelimiter();
        }
        this.init();
    }

    private void init() throws IOException {
        this._parser = this._format.parse(RecordReaderUtils.getFileReader(this._dataFile));
        this._iterator = this._parser.iterator();
    }

    @Override
    public boolean hasNext() {
        return this._iterator.hasNext();
    }

    @Override
    public GenericRow next() {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) {
        CSVRecord record = this._iterator.next();
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            Object value;
            String token;
            String column = fieldSpec.getName();
            String string = token = record.isSet(column) ? record.get(column) : null;
            if (fieldSpec.isSingleValueField()) {
                value = RecordReaderUtils.convertToDataType(token, fieldSpec);
            } else {
                String[] tokens = token != null ? StringUtils.split(token, this._multiValueDelimiter) : null;
                value = RecordReaderUtils.convertToDataTypeArray(tokens, fieldSpec);
            }
            reuse.putField(column, value);
        }
        return reuse;
    }

    @Override
    public void rewind() throws IOException {
        this._parser.close();
        this.init();
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public void close() throws IOException {
        this._parser.close();
    }
}

