/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.common.data.Schema;

public class GenericRowRecordReader
implements RecordReader {
    private final List<GenericRow> _rows;
    private final int _numRows;
    private final Schema _schema;
    private int _nextRowId = 0;

    public GenericRowRecordReader(List<GenericRow> rows, Schema schema) {
        this._rows = rows;
        this._numRows = rows.size();
        this._schema = schema;
    }

    @Override
    public boolean hasNext() {
        return this._nextRowId < this._numRows;
    }

    @Override
    public GenericRow next() {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) {
        for (Map.Entry<String, Object> entry : this._rows.get(this._nextRowId++).getEntrySet()) {
            reuse.putField(entry.getKey(), entry.getValue());
        }
        return reuse;
    }

    @Override
    public void rewind() {
        this._nextRowId = 0;
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public void close() {
    }
}

