/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReaderUtils;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.utils.JsonUtils;

public class JSONRecordReader
implements RecordReader {
    private final JsonFactory _factory = new JsonFactory();
    private final File _dataFile;
    private final Schema _schema;
    private JsonParser _parser;
    private Iterator<Map> _iterator;

    public JSONRecordReader(File dataFile, Schema schema) throws IOException {
        this._dataFile = dataFile;
        this._schema = schema;
        this.init();
    }

    private void init() throws IOException {
        this._parser = this._factory.createParser(RecordReaderUtils.getFileReader(this._dataFile));
        try {
            this._iterator = JsonUtils.DEFAULT_MAPPER.readValues(this._parser, Map.class);
        }
        catch (Exception e) {
            this._parser.close();
            throw e;
        }
    }

    @Override
    public boolean hasNext() {
        return this._iterator.hasNext();
    }

    @Override
    public GenericRow next() {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) {
        Map record = this._iterator.next();
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            Object value;
            String fieldName = fieldSpec.getName();
            Object jsonValue = record.get(fieldName);
            if (fieldSpec.isSingleValueField()) {
                String token = jsonValue != null ? jsonValue.toString() : null;
                value = RecordReaderUtils.convertToDataType(token, fieldSpec);
            } else {
                value = RecordReaderUtils.convertToDataTypeArray((ArrayList)jsonValue, fieldSpec);
            }
            reuse.putField(fieldName, value);
        }
        return reuse;
    }

    @Override
    public void rewind() throws IOException {
        this._parser.close();
        this.init();
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public void close() throws IOException {
        this._parser.close();
    }
}

