/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import java.io.File;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.AvroRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.CSVRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.CSVRecordReaderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.FileFormat;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.JSONRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.PinotSegmentRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.ThriftRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.ThriftRecordReaderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.common.data.Schema;

public class RecordReaderFactory {
    private RecordReaderFactory() {
    }

    public static RecordReader getRecordReader(SegmentGeneratorConfig segmentGeneratorConfig) throws Exception {
        File dataFile = new File(segmentGeneratorConfig.getInputFilePath());
        Preconditions.checkState(dataFile.exists(), "Input file: " + dataFile.getAbsolutePath() + " does not exist");
        Schema schema = segmentGeneratorConfig.getSchema();
        FileFormat fileFormat = segmentGeneratorConfig.getFormat();
        switch (fileFormat) {
            case AVRO: 
            case GZIPPED_AVRO: {
                return new AvroRecordReader(dataFile, schema);
            }
            case CSV: {
                return new CSVRecordReader(dataFile, schema, (CSVRecordReaderConfig)segmentGeneratorConfig.getReaderConfig());
            }
            case JSON: {
                return new JSONRecordReader(dataFile, schema);
            }
            case PINOT: {
                return new PinotSegmentRecordReader(dataFile, schema, segmentGeneratorConfig.getColumnSortOrder());
            }
            case THRIFT: {
                return new ThriftRecordReader(dataFile, schema, (ThriftRecordReaderConfig)segmentGeneratorConfig.getReaderConfig());
            }
        }
        throw new UnsupportedOperationException("Unsupported input file format: " + (Object)((Object)fileFormat));
    }
}

