/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReaderUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.ThriftRecordReaderConfig;
import org.apache.pinot.$internal.org.apache.thrift.TBase;
import org.apache.pinot.$internal.org.apache.thrift.TFieldIdEnum;
import org.apache.pinot.$internal.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.pinot.$internal.org.apache.thrift.transport.TIOStreamTransport;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;

public class ThriftRecordReader
implements RecordReader {
    private final Schema _schema;
    private final ThriftRecordReaderConfig _recordReaderConfig;
    private final Class<TBase<?, ?>> _thriftClass;
    private TBinaryProtocol _binaryIn;
    private BufferedInputStream _bufferIn;
    private final File _dataFile;
    Map<String, Integer> _fieldNameToIndexMap;

    public ThriftRecordReader(File dataFile, Schema schema, ThriftRecordReaderConfig recordReaderConfig) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._schema = schema;
        this._dataFile = dataFile;
        this._recordReaderConfig = recordReaderConfig;
        this._thriftClass = this.initThriftInstanceCreator();
        this._bufferIn = RecordReaderUtils.getFileBufferStream(dataFile);
        this._binaryIn = new TBinaryProtocol(new TIOStreamTransport(this._bufferIn));
        this._fieldNameToIndexMap = new HashMap<String, Integer>();
        TBase<?, ?> t = this._thriftClass.newInstance();
        int index = 1;
        TFieldIdEnum fieldIdEnum = null;
        do {
            if ((fieldIdEnum = (TFieldIdEnum)t.fieldForId(index)) != null) {
                this._fieldNameToIndexMap.put(fieldIdEnum.getFieldName(), index);
            }
            ++index;
        } while (fieldIdEnum != null);
    }

    @Override
    public boolean hasNext() {
        this._bufferIn.mark(1);
        int val = 0;
        try {
            val = this._bufferIn.read();
            this._bufferIn.reset();
        }
        catch (IOException e) {
            val = -1;
            throw new RuntimeException("Error in iterating Reader", e);
        }
        return val != -1;
    }

    @Override
    public GenericRow next() throws IOException {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) throws IOException {
        TBase<?, ?> t = null;
        try {
            t = this._thriftClass.newInstance();
            t.read(this._binaryIn);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while serialize thrift instance", e);
        }
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            String fieldName = fieldSpec.getName();
            if (!this._fieldNameToIndexMap.containsKey(fieldName)) continue;
            int tFieldId = this._fieldNameToIndexMap.get(fieldName);
            Object tFieldIdEnum = t.fieldForId(tFieldId);
            Object thriftValue = t.getFieldValue(tFieldIdEnum);
            Object value = null;
            if (fieldSpec.isSingleValueField()) {
                String token = thriftValue != null ? thriftValue.toString() : null;
                value = RecordReaderUtils.convertToDataType(token, fieldSpec);
            } else if (thriftValue instanceof ArrayList) {
                value = RecordReaderUtils.convertToDataTypeArray((ArrayList)thriftValue, fieldSpec);
            } else if (thriftValue instanceof HashSet) {
                value = RecordReaderUtils.convertToDataTypeSet((HashSet)thriftValue, fieldSpec);
            }
            reuse.putField(fieldName, value);
        }
        return reuse;
    }

    @Override
    public void rewind() throws IOException {
        this._bufferIn = RecordReaderUtils.getFileBufferStream(this._dataFile);
        this._binaryIn = new TBinaryProtocol(new TIOStreamTransport(this._bufferIn));
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public void close() throws IOException {
        this._bufferIn.close();
    }

    private Class<TBase<?, ?>> initThriftInstanceCreator() {
        Class<TBase<?, ?>> tBase = null;
        if (this._recordReaderConfig == null || this._recordReaderConfig.getThriftClass() == null) {
            throw new IllegalArgumentException("Thrift class not found in the configuration");
        }
        try {
            tBase = Class.forName(this._recordReaderConfig.getThriftClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Caught exception while thrift class initialize", e);
        }
        return tBase;
    }
}

