/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.readers.sort;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.PinotSegmentColumnReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.sort.SegmentSorter;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;

public class PinotSegmentSorter
implements SegmentSorter {
    private int _numDocs;
    private Schema _schema;
    private Map<String, PinotSegmentColumnReader> _columnReaderMap;
    private int[] _sortOrder;
    private List<String> _dimensionNames;
    int _numDimensions;

    public PinotSegmentSorter(int numDocs, Schema schema, Map<String, PinotSegmentColumnReader> columnReaderMap) {
        this._numDocs = numDocs;
        this._schema = schema;
        this._columnReaderMap = columnReaderMap;
        this._dimensionNames = new ArrayList<String>();
        for (FieldSpec fieldSpec : this._schema.getAllFieldSpecs()) {
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) continue;
            String dimensionName = fieldSpec.getName();
            ++this._numDimensions;
            this._dimensionNames.add(dimensionName);
        }
    }

    @Override
    public int[] getSortedDocIds(List<String> sortOrder) {
        this._sortOrder = new int[sortOrder.size()];
        int index = 0;
        for (String dimension : sortOrder) {
            int dimensionId = this._dimensionNames.indexOf(dimension);
            if (dimensionId != -1) {
                this._sortOrder[index++] = dimensionId;
                continue;
            }
            throw new IllegalStateException("Passed dimension in the sorting order does not exist in the schema: " + dimension);
        }
        final int[] sortedDocIds = new int[this._numDocs];
        for (int i = 0; i < this._numDocs; ++i) {
            sortedDocIds[i] = i;
        }
        IntComparator comparator = new IntComparator(){

            public int compare(int i1, int i2) {
                int docId1 = sortedDocIds[i1];
                int docId2 = sortedDocIds[i2];
                int compare = 0;
                for (int index : PinotSegmentSorter.this._sortOrder) {
                    boolean isNoDictionaryColumn;
                    String dimensionName = (String)PinotSegmentSorter.this._dimensionNames.get(index);
                    FieldSpec fieldSpec = PinotSegmentSorter.this._schema.getFieldSpecFor(dimensionName);
                    PinotSegmentColumnReader columnReader = (PinotSegmentColumnReader)PinotSegmentSorter.this._columnReaderMap.get(dimensionName);
                    boolean isMultiValueColumn = !fieldSpec.isSingleValueField();
                    boolean bl = isNoDictionaryColumn = !columnReader.hasDictionary();
                    if (isMultiValueColumn || isNoDictionaryColumn) {
                        throw new IllegalStateException("Multi value column or no dictionary column is not supported. ( column name: " + dimensionName + ", multi value column: " + isMultiValueColumn + ", no dictionary column: " + isNoDictionaryColumn + " )");
                    }
                    compare = columnReader.getDictionaryId(docId1) - columnReader.getDictionaryId(docId2);
                    if (compare == 0) continue;
                    return compare;
                }
                return compare;
            }

            public int compare(Integer o1, Integer o2) {
                throw new UnsupportedOperationException();
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int i, int j) {
                int temp = sortedDocIds[i];
                sortedDocIds[i] = sortedDocIds[j];
                sortedDocIds[j] = temp;
            }
        };
        Arrays.quickSort((int)0, (int)this._numDocs, (IntComparator)comparator, (Swapper)swapper);
        return sortedDocIds;
    }
}

