/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.PinotDataType;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;

public class DataTypeTransformer
implements RecordTransformer {
    private static final Map<Class, PinotDataType> SINGLE_VALUE_TYPE_MAP = new HashMap<Class, PinotDataType>();
    private static final Map<Class, PinotDataType> MULTI_VALUE_TYPE_MAP = new HashMap<Class, PinotDataType>();
    private final Schema _schema;
    private final Map<String, PinotDataType> _dataTypes = new HashMap<String, PinotDataType>();

    public DataTypeTransformer(Schema schema) {
        this._schema = schema;
        for (Map.Entry<String, FieldSpec> entry : schema.getFieldSpecMap().entrySet()) {
            this._dataTypes.put(entry.getKey(), PinotDataType.getPinotDataType(entry.getValue()));
        }
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, PinotDataType> entry : this._dataTypes.entrySet()) {
            PinotDataType source;
            String column = entry.getKey();
            PinotDataType dest = entry.getValue();
            Object value = record.getValue(column);
            if (value == null) {
                FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
                Object defaultNullValue = fieldSpec.getDefaultNullValue();
                value = fieldSpec.isSingleValueField() ? defaultNullValue : new Object[]{defaultNullValue};
                record.putField(column, value);
                continue;
            }
            if (value instanceof Object[]) {
                Object[] values = value;
                assert (values.length > 0);
                source = MULTI_VALUE_TYPE_MAP.get(values[0].getClass());
                if (source == null) {
                    source = PinotDataType.OBJECT_ARRAY;
                }
            } else {
                source = SINGLE_VALUE_TYPE_MAP.get(value.getClass());
                if (source == null) {
                    source = PinotDataType.OBJECT;
                }
            }
            if (source == dest) continue;
            value = dest.convert(value, source);
            record.putField(column, value);
        }
        return record;
    }

    static {
        SINGLE_VALUE_TYPE_MAP.put(Boolean.class, PinotDataType.BOOLEAN);
        SINGLE_VALUE_TYPE_MAP.put(Byte.class, PinotDataType.BYTE);
        SINGLE_VALUE_TYPE_MAP.put(Character.class, PinotDataType.CHARACTER);
        SINGLE_VALUE_TYPE_MAP.put(Short.class, PinotDataType.SHORT);
        SINGLE_VALUE_TYPE_MAP.put(Integer.class, PinotDataType.INTEGER);
        SINGLE_VALUE_TYPE_MAP.put(Long.class, PinotDataType.LONG);
        SINGLE_VALUE_TYPE_MAP.put(Float.class, PinotDataType.FLOAT);
        SINGLE_VALUE_TYPE_MAP.put(Double.class, PinotDataType.DOUBLE);
        SINGLE_VALUE_TYPE_MAP.put(String.class, PinotDataType.STRING);
        SINGLE_VALUE_TYPE_MAP.put(byte[].class, PinotDataType.BYTES);
        MULTI_VALUE_TYPE_MAP.put(Byte.class, PinotDataType.BYTE_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Character.class, PinotDataType.CHARACTER_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Short.class, PinotDataType.SHORT_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Integer.class, PinotDataType.INTEGER_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Long.class, PinotDataType.LONG_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Float.class, PinotDataType.FLOAT_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(Double.class, PinotDataType.DOUBLE_ARRAY);
        MULTI_VALUE_TYPE_MAP.put(String.class, PinotDataType.STRING_ARRAY);
    }
}

