/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.indexsegment;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.DataFileReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnMultiValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.common.data.FieldSpec;

public class IndexSegmentUtils {
    private IndexSegmentUtils() {
    }

    public static Object getValue(int docId, @Nonnull FieldSpec fieldSpec, @Nonnull DataFileReader forwardIndex, @Nullable Dictionary dictionary, int maxNumMultiValues) {
        if (dictionary != null) {
            if (fieldSpec.isSingleValueField()) {
                int dictId = ((SingleColumnSingleValueReader)forwardIndex).getInt(docId);
                return dictionary.get(dictId);
            }
            int[] dictIds = new int[maxNumMultiValues];
            int numValues = ((SingleColumnMultiValueReader)forwardIndex).getIntArray(docId, dictIds);
            Object[] value = new Object[numValues];
            for (int i = 0; i < numValues; ++i) {
                value[i] = dictionary.get(dictIds[i]);
            }
            return value;
        }
        SingleColumnSingleValueReader singleValueReader = (SingleColumnSingleValueReader)forwardIndex;
        switch (fieldSpec.getDataType()) {
            case INT: {
                return singleValueReader.getInt(docId);
            }
            case LONG: {
                return singleValueReader.getLong(docId);
            }
            case FLOAT: {
                return Float.valueOf(singleValueReader.getFloat(docId));
            }
            case DOUBLE: {
                return singleValueReader.getDouble(docId);
            }
            case STRING: {
                return singleValueReader.getString(docId);
            }
        }
        throw new IllegalStateException();
    }
}

