/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.lang.StringUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.CSVRecordReaderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.FileFormat;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReaderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.name.FixedSegmentNameGenerator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.name.SegmentNameGenerator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.name.SimpleSegmentNameGenerator;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.util.AvroUtils;
import org.apache.pinot.common.config.IndexingConfig;
import org.apache.pinot.common.config.SegmentPartitionConfig;
import org.apache.pinot.common.config.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.common.config.StarTreeIndexConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.data.StarTreeIndexSpec;
import org.apache.pinot.common.data.TimeFieldSpec;
import org.apache.pinot.common.utils.JsonUtils;
import org.apache.pinot.startree.hll.HllConfig;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SegmentGeneratorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentGeneratorConfig.class);
    private Map<String, String> _customProperties = new HashMap<String, String>();
    private Set<String> _rawIndexCreationColumns = new HashSet<String>();
    private Map<String, .ChunkCompressorFactory.CompressionType> _rawIndexCompressionType = new HashMap<String, .ChunkCompressorFactory.CompressionType>();
    private List<String> _invertedIndexCreationColumns = new ArrayList<String>();
    private List<String> _columnSortOrder = new ArrayList<String>();
    private String _dataDir = null;
    private String _inputFilePath = null;
    private FileFormat _format = FileFormat.AVRO;
    private String _outDir = null;
    private boolean _overwrite = false;
    private String _tableName = null;
    private String _segmentName = null;
    private String _segmentNamePostfix = null;
    private String _segmentTimeColumnName = null;
    private TimeUnit _segmentTimeUnit = null;
    private String _segmentCreationTime = null;
    private String _segmentStartTime = null;
    private String _segmentEndTime = null;
    private SegmentVersion _segmentVersion = SegmentVersion.v3;
    private String _schemaFile = null;
    private Schema _schema = null;
    private String _readerConfigFile = null;
    private RecordReaderConfig _readerConfig = null;
    private boolean _enableStarTreeIndex = false;
    private StarTreeIndexSpec _starTreeIndexSpec = null;
    private List<StarTreeV2BuilderConfig> _starTreeV2BuilderConfigs = null;
    private String _creatorVersion = null;
    private HllConfig _hllConfig = null;
    private SegmentNameGenerator _segmentNameGenerator = null;
    private SegmentPartitionConfig _segmentPartitionConfig = null;
    private int _sequenceId = -1;
    private TimeColumnType _timeColumnType = TimeColumnType.EPOCH;
    private String _simpleDateFormat = null;
    private boolean _onHeap = false;

    public SegmentGeneratorConfig() {
    }

    @Deprecated
    public SegmentGeneratorConfig(SegmentGeneratorConfig config) {
        Preconditions.checkNotNull(config);
        this._customProperties.putAll(config._customProperties);
        this._rawIndexCreationColumns.addAll(config._rawIndexCreationColumns);
        this._rawIndexCompressionType.putAll(config._rawIndexCompressionType);
        this._invertedIndexCreationColumns.addAll(config._invertedIndexCreationColumns);
        this._columnSortOrder.addAll(config._columnSortOrder);
        this._dataDir = config._dataDir;
        this._inputFilePath = config._inputFilePath;
        this._format = config._format;
        this._outDir = config._outDir;
        this._overwrite = config._overwrite;
        this._tableName = config._tableName;
        this._segmentName = config._segmentName;
        this._segmentNamePostfix = config._segmentNamePostfix;
        this._segmentTimeColumnName = config._segmentTimeColumnName;
        this._segmentTimeUnit = config._segmentTimeUnit;
        this._segmentCreationTime = config._segmentCreationTime;
        this._segmentStartTime = config._segmentStartTime;
        this._segmentEndTime = config._segmentEndTime;
        this._segmentVersion = config._segmentVersion;
        this._schemaFile = config._schemaFile;
        this._schema = config._schema;
        this._readerConfigFile = config._readerConfigFile;
        this._readerConfig = config._readerConfig;
        this._enableStarTreeIndex = config._enableStarTreeIndex;
        this._starTreeIndexSpec = config._starTreeIndexSpec;
        this._starTreeV2BuilderConfigs = config._starTreeV2BuilderConfigs;
        this._creatorVersion = config._creatorVersion;
        this._hllConfig = config._hllConfig;
        this._segmentNameGenerator = config._segmentNameGenerator;
        this._segmentPartitionConfig = config._segmentPartitionConfig;
        this._sequenceId = config._sequenceId;
        this._timeColumnType = config._timeColumnType;
        this._simpleDateFormat = config._simpleDateFormat;
        this._onHeap = config._onHeap;
    }

    public SegmentGeneratorConfig(@Nullable TableConfig tableConfig, Schema schema) {
        List<StarTreeIndexConfig> starTreeIndexConfigs;
        Preconditions.checkNotNull(schema);
        this._schema = schema;
        if (tableConfig == null) {
            return;
        }
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        List<String> noDictionaryColumns = indexingConfig.getNoDictionaryColumns();
        Map<String, String> noDictionaryColumnMap = indexingConfig.getNoDictionaryConfig();
        if (noDictionaryColumns != null) {
            this.setRawIndexCreationColumns(noDictionaryColumns);
            if (noDictionaryColumnMap != null) {
                Map<String, .ChunkCompressorFactory.CompressionType> serializedNoDictionaryColumnMap = noDictionaryColumnMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> .ChunkCompressorFactory.CompressionType.valueOf((String)e.getValue())));
                this.setRawIndexCompressionType(serializedNoDictionaryColumnMap);
            }
        }
        this._segmentPartitionConfig = indexingConfig.getSegmentPartitionConfig();
        StarTreeIndexSpec starTreeIndexSpec = indexingConfig.getStarTreeIndexSpec();
        if (starTreeIndexSpec != null) {
            this.enableStarTreeIndex(starTreeIndexSpec);
        }
        if ((starTreeIndexConfigs = indexingConfig.getStarTreeIndexConfigs()) != null && !starTreeIndexConfigs.isEmpty()) {
            ArrayList<StarTreeV2BuilderConfig> starTreeV2BuilderConfigs = new ArrayList<StarTreeV2BuilderConfig>(starTreeIndexConfigs.size());
            for (StarTreeIndexConfig starTreeIndexConfig : starTreeIndexConfigs) {
                starTreeV2BuilderConfigs.add(StarTreeV2BuilderConfig.fromIndexConfig(starTreeIndexConfig));
            }
            this.setStarTreeV2BuilderConfigs(starTreeV2BuilderConfigs);
        }
        if (indexingConfig.isCreateInvertedIndexDuringSegmentGeneration()) {
            this._invertedIndexCreationColumns = indexingConfig.getInvertedIndexColumns();
        }
        SegmentsValidationAndRetentionConfig validationConfig = tableConfig.getValidationConfig();
        this._hllConfig = validationConfig.getHllConfig();
    }

    public SegmentGeneratorConfig(Schema schema) {
        this._schema = schema;
    }

    public Map<String, String> getCustomProperties() {
        return this._customProperties;
    }

    public void setCustomProperties(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this._customProperties.putAll(properties);
    }

    public void setSimpleDateFormat(@Nonnull String simpleDateFormat) {
        this._timeColumnType = TimeColumnType.SIMPLE_DATE;
        try {
            DateTimeFormat.forPattern((String)simpleDateFormat);
        }
        catch (Exception e) {
            throw new RuntimeException("Illegal simple date format specification", e);
        }
        this._simpleDateFormat = simpleDateFormat;
    }

    public String getSimpleDateFormat() {
        return this._simpleDateFormat;
    }

    public TimeColumnType getTimeColumnType() {
        return this._timeColumnType;
    }

    public boolean containsCustomProperty(String key) {
        Preconditions.checkNotNull(key);
        return this._customProperties.containsKey(key);
    }

    public Set<String> getRawIndexCreationColumns() {
        return this._rawIndexCreationColumns;
    }

    public List<String> getInvertedIndexCreationColumns() {
        return this._invertedIndexCreationColumns;
    }

    public List<String> getColumnSortOrder() {
        return this._columnSortOrder;
    }

    public void setRawIndexCreationColumns(List<String> rawIndexCreationColumns) {
        Preconditions.checkNotNull(rawIndexCreationColumns);
        this._rawIndexCreationColumns.addAll(rawIndexCreationColumns);
    }

    public void setInvertedIndexCreationColumns(List<String> indexCreationColumns) {
        Preconditions.checkNotNull(indexCreationColumns);
        this._invertedIndexCreationColumns.addAll(indexCreationColumns);
    }

    public void setColumnSortOrder(List<String> sortOrder) {
        Preconditions.checkNotNull(sortOrder);
        this._columnSortOrder.addAll(sortOrder);
    }

    public void createInvertedIndexForColumn(String column) {
        Preconditions.checkNotNull(column);
        if (this._schema != null && this._schema.getFieldSpecFor(column) == null) {
            LOGGER.warn("Cannot find column {} in schema, will not create inverted index.", (Object)column);
            return;
        }
        if (this._schema == null) {
            LOGGER.warn("Schema has not been set, column {} might not exist in schema after all.", (Object)column);
        }
        this._invertedIndexCreationColumns.add(column);
    }

    public void createInvertedIndexForAllColumns() {
        if (this._schema == null) {
            LOGGER.warn("Schema has not been set, will not create inverted index for all columns.");
            return;
        }
        for (FieldSpec spec : this._schema.getAllFieldSpecs()) {
            this._invertedIndexCreationColumns.add(spec.getName());
        }
    }

    public String getDataDir() {
        return this._dataDir;
    }

    public void setDataDir(String dataDir) {
        this._dataDir = dataDir;
    }

    public String getInputFilePath() {
        return this._inputFilePath;
    }

    public void setInputFilePath(String inputFilePath) {
        Preconditions.checkNotNull(inputFilePath);
        File inputFile = new File(inputFilePath);
        Preconditions.checkState(inputFile.exists(), "Input path {} does not exist.", (Object)inputFilePath);
        this._inputFilePath = inputFile.getAbsolutePath();
    }

    public FileFormat getFormat() {
        return this._format;
    }

    public void setFormat(FileFormat format) {
        this._format = format;
    }

    public String getOutDir() {
        return this._outDir;
    }

    public void setOutDir(String dir) {
        Preconditions.checkNotNull(dir);
        File outputDir = new File(dir);
        if (outputDir.exists()) {
            Preconditions.checkState(outputDir.isDirectory(), "Path {} is not a directory.", (Object)dir);
        } else {
            Preconditions.checkState(outputDir.mkdirs(), "Cannot create output dir: {}", (Object)dir);
        }
        this._outDir = outputDir.getAbsolutePath();
    }

    public boolean isOverwrite() {
        return this._overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this._overwrite = overwrite;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public void setSegmentName(String segmentName) {
        this._segmentName = segmentName;
    }

    public String getCreatorVersion() {
        return this._creatorVersion;
    }

    public void setCreatorVersion(String creatorVersion) {
        this._creatorVersion = creatorVersion;
    }

    public String getSegmentNamePostfix() {
        return this._segmentNamePostfix;
    }

    public void setSegmentNamePostfix(String postfix) {
        this._segmentNamePostfix = postfix;
    }

    public String getTimeColumnName() {
        if (this._segmentTimeColumnName != null) {
            return this._segmentTimeColumnName;
        }
        return this.getQualifyingFields(FieldSpec.FieldType.TIME, true);
    }

    public void setTimeColumnName(String timeColumnName) {
        this._segmentTimeColumnName = timeColumnName;
    }

    public int getSequenceId() {
        return this._sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this._sequenceId = sequenceId;
    }

    public TimeUnit getSegmentTimeUnit() {
        if (this._segmentTimeUnit != null) {
            return this._segmentTimeUnit;
        }
        TimeFieldSpec timeFieldSpec = this._schema.getTimeFieldSpec();
        if (timeFieldSpec != null) {
            return timeFieldSpec.getOutgoingGranularitySpec().getTimeType();
        }
        return TimeUnit.DAYS;
    }

    public void setSegmentTimeUnit(TimeUnit timeUnit) {
        this._segmentTimeUnit = timeUnit;
    }

    public String getCreationTime() {
        return this._segmentCreationTime;
    }

    public void setCreationTime(String creationTime) {
        this._segmentCreationTime = creationTime;
    }

    public String getStartTime() {
        return this._segmentStartTime;
    }

    public void setStartTime(String startTime) {
        this._segmentStartTime = startTime;
    }

    public String getEndTime() {
        return this._segmentEndTime;
    }

    public void setEndTime(String endTime) {
        this._segmentEndTime = endTime;
    }

    public SegmentVersion getSegmentVersion() {
        return this._segmentVersion;
    }

    public void setSegmentVersion(SegmentVersion segmentVersion) {
        this._segmentVersion = segmentVersion;
    }

    public String getSchemaFile() {
        return this._schemaFile;
    }

    public void setSchemaFile(String schemaFile) {
        this._schemaFile = schemaFile;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void setSchema(Schema schema) {
        Preconditions.checkNotNull(schema);
        this._schema = schema;
        if (this._invertedIndexCreationColumns != null) {
            Iterator<String> iterator = this._invertedIndexCreationColumns.iterator();
            while (iterator.hasNext()) {
                String column = iterator.next();
                if (this._schema.getFieldSpecFor(column) != null) continue;
                LOGGER.warn("Cannot find column {} in schema, will not create inverted index.", (Object)column);
                iterator.remove();
            }
        }
    }

    public String getReaderConfigFile() {
        return this._readerConfigFile;
    }

    public void setReaderConfigFile(String readerConfigFile) {
        this._readerConfigFile = readerConfigFile;
    }

    public RecordReaderConfig getReaderConfig() {
        return this._readerConfig;
    }

    public void setReaderConfig(RecordReaderConfig readerConfig) {
        this._readerConfig = readerConfig;
    }

    public boolean isEnableStarTreeIndex() {
        return this._enableStarTreeIndex;
    }

    public void setEnableStarTreeIndex(boolean enableStarTreeIndex) {
        this._enableStarTreeIndex = enableStarTreeIndex;
    }

    public StarTreeIndexSpec getStarTreeIndexSpec() {
        return this._starTreeIndexSpec;
    }

    public void setStarTreeIndexSpec(StarTreeIndexSpec starTreeIndexSpec) {
        this._starTreeIndexSpec = starTreeIndexSpec;
    }

    public void enableStarTreeIndex(@Nullable StarTreeIndexSpec starTreeIndexSpec) {
        this.setEnableStarTreeIndex(true);
        this.setStarTreeIndexSpec(starTreeIndexSpec);
    }

    public List<StarTreeV2BuilderConfig> getStarTreeV2BuilderConfigs() {
        return this._starTreeV2BuilderConfigs;
    }

    public void setStarTreeV2BuilderConfigs(List<StarTreeV2BuilderConfig> starTreeV2BuilderConfigs) {
        this._starTreeV2BuilderConfigs = starTreeV2BuilderConfigs;
    }

    public HllConfig getHllConfig() {
        return this._hllConfig;
    }

    public void setHllConfig(HllConfig hllConfig) {
        this._hllConfig = hllConfig;
    }

    public SegmentNameGenerator getSegmentNameGenerator() {
        if (this._segmentNameGenerator != null) {
            return this._segmentNameGenerator;
        }
        if (this._segmentName != null) {
            return new FixedSegmentNameGenerator(this._segmentName);
        }
        return new SimpleSegmentNameGenerator(this._tableName, this._segmentNamePostfix);
    }

    public void setSegmentNameGenerator(SegmentNameGenerator segmentNameGenerator) {
        this._segmentNameGenerator = segmentNameGenerator;
    }

    public boolean isOnHeap() {
        return this._onHeap;
    }

    public void setOnHeap(boolean onHeap) {
        this._onHeap = onHeap;
    }

    public Map<String, .ChunkCompressorFactory.CompressionType> getRawIndexCompressionType() {
        return this._rawIndexCompressionType;
    }

    public void setRawIndexCompressionType(Map<String, .ChunkCompressorFactory.CompressionType> rawIndexCompressionType) {
        this._rawIndexCompressionType.clear();
        this._rawIndexCompressionType.putAll(rawIndexCompressionType);
    }

    @JsonIgnore
    public String getMetrics() {
        return this.getQualifyingFields(FieldSpec.FieldType.METRIC, true);
    }

    @Deprecated
    public void loadConfigFiles() throws IOException {
        Schema schema;
        if (this._schemaFile != null) {
            schema = Schema.fromFile(new File(this._schemaFile));
            this.setSchema(schema);
        } else if (this._format == FileFormat.AVRO) {
            schema = AvroUtils.getPinotSchemaFromAvroDataFile(new File(this._inputFilePath));
            this.setSchema(schema);
        } else {
            throw new RuntimeException("Input format " + (Object)((Object)this._format) + " requires schema.");
        }
        this.setTimeColumnName(schema.getTimeColumnName());
        TimeFieldSpec timeFieldSpec = schema.getTimeFieldSpec();
        if (timeFieldSpec != null) {
            this.setSegmentTimeUnit(timeFieldSpec.getIncomingGranularitySpec().getTimeType());
        } else {
            this.setSegmentTimeUnit(TimeUnit.DAYS);
        }
        if (this._readerConfigFile != null) {
            this.setReaderConfig(JsonUtils.fileToObject(new File(this._readerConfigFile), CSVRecordReaderConfig.class));
        }
    }

    @JsonIgnore
    public String getDimensions() {
        return this.getQualifyingFields(FieldSpec.FieldType.DIMENSION, true);
    }

    @JsonIgnore
    public String getDateTimeColumnNames() {
        return this.getQualifyingFields(FieldSpec.FieldType.DATE_TIME, true);
    }

    public void setSegmentPartitionConfig(SegmentPartitionConfig segmentPartitionConfig) {
        this._segmentPartitionConfig = segmentPartitionConfig;
    }

    public SegmentPartitionConfig getSegmentPartitionConfig() {
        return this._segmentPartitionConfig;
    }

    @JsonIgnore
    private String getQualifyingFields(FieldSpec.FieldType type, boolean excludeVirtualColumns) {
        ArrayList<String> fields = new ArrayList<String>();
        for (FieldSpec spec : this.getSchema().getAllFieldSpecs()) {
            if (excludeVirtualColumns && this.getSchema().isVirtualColumn(spec.getName()) || spec.getFieldType() != type) continue;
            fields.add(spec.getName());
        }
        Collections.sort(fields);
        return StringUtils.join(fields, ",");
    }

    public static enum TimeColumnType {
        EPOCH,
        SIMPLE_DATE;

    }
}

