/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.IndexSegmentUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.immutable.ImmutableSegment;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.DataFileReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.data.source.ColumnDataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store.StarTreeIndexContainer;
import org.apache.pinot.common.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableSegmentImpl
implements ImmutableSegment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableSegmentImpl.class);
    private final SegmentDirectory _segmentDirectory;
    private final SegmentMetadataImpl _segmentMetadata;
    private final Map<String, ColumnIndexContainer> _indexContainerMap;
    private final StarTreeIndexContainer _starTreeIndexContainer;

    public ImmutableSegmentImpl(SegmentDirectory segmentDirectory, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> columnIndexContainerMap, @Nullable StarTreeIndexContainer starTreeIndexContainer) {
        this._segmentDirectory = segmentDirectory;
        this._segmentMetadata = segmentMetadata;
        this._indexContainerMap = columnIndexContainerMap;
        this._starTreeIndexContainer = starTreeIndexContainer;
    }

    @Override
    public Dictionary getDictionary(String column) {
        return this._indexContainerMap.get(column).getDictionary();
    }

    @Override
    public DataFileReader getForwardIndex(String column) {
        return this._indexContainerMap.get(column).getForwardIndex();
    }

    @Override
    public InvertedIndexReader getInvertedIndex(String column) {
        return this._indexContainerMap.get(column).getInvertedIndex();
    }

    @Override
    public long getSegmentSizeBytes() {
        return this._segmentDirectory.getDiskSizeBytes();
    }

    @Override
    public String getSegmentName() {
        return this._segmentMetadata.getName();
    }

    @Override
    public SegmentMetadataImpl getSegmentMetadata() {
        return this._segmentMetadata;
    }

    @Override
    public ColumnDataSource getDataSource(String column) {
        return new ColumnDataSource(this._indexContainerMap.get(column), this._segmentMetadata.getColumnMetadataFor(column));
    }

    @Override
    public Set<String> getColumnNames() {
        return this._segmentMetadata.getSchema().getColumnNames();
    }

    @Override
    public Set<String> getPhysicalColumnNames() {
        HashSet<String> physicalColumnNames = new HashSet<String>();
        for (String columnName : this.getColumnNames()) {
            if (this._segmentMetadata.getSchema().isVirtualColumn(columnName)) continue;
            physicalColumnNames.add(columnName);
        }
        return physicalColumnNames;
    }

    @Override
    public void destroy() {
        LOGGER.info("Trying to destroy segment : {}", (Object)this.getSegmentName());
        for (String column : this._indexContainerMap.keySet()) {
            ColumnIndexContainer columnIndexContainer = this._indexContainerMap.get(column);
            try {
                Dictionary dictionary = columnIndexContainer.getDictionary();
                if (dictionary != null) {
                    dictionary.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error when close dictionary index for column : " + column, (Throwable)e);
            }
            try {
                columnIndexContainer.getForwardIndex().close();
            }
            catch (Exception e) {
                LOGGER.error("Error when close forward index for column : " + column, (Throwable)e);
            }
            try {
                InvertedIndexReader invertedIndex = columnIndexContainer.getInvertedIndex();
                if (invertedIndex == null) continue;
                invertedIndex.close();
            }
            catch (Exception e) {
                LOGGER.error("Error when close inverted index for column : " + column, (Throwable)e);
            }
        }
        try {
            this._segmentDirectory.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close segment directory: {}. Continuing with error.", (Object)this._segmentDirectory, (Object)e);
        }
        this._indexContainerMap.clear();
        try {
            if (this._starTreeIndexContainer != null) {
                this._starTreeIndexContainer.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to close star-tree. Continuing with error.", (Throwable)e);
        }
    }

    @Override
    public List<StarTreeV2> getStarTrees() {
        return this._starTreeIndexContainer != null ? this._starTreeIndexContainer.getStarTrees() : null;
    }

    @Override
    public GenericRow getRecord(int docId, GenericRow reuse) {
        for (FieldSpec fieldSpec : this._segmentMetadata.getSchema().getAllFieldSpecs()) {
            String column = fieldSpec.getName();
            ColumnIndexContainer indexContainer = this._indexContainerMap.get(column);
            reuse.putField(column, IndexSegmentUtils.getValue(docId, fieldSpec, indexContainer.getForwardIndex(), indexContainer.getDictionary(), this._segmentMetadata.getColumnMetadataFor(column).getMaxNumberOfMultiValues()));
        }
        return reuse;
    }
}

