/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.compression;

import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkCompressor;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkDecompressor;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.PassThroughCompressor;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.PassThroughDecompressor;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.SnappyCompressor;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.SnappyDecompressor;

public class ChunkCompressorFactory {
    private ChunkCompressorFactory() {
    }

    public static ChunkCompressor getCompressor(CompressionType compressionType) {
        switch (compressionType) {
            case PASS_THROUGH: {
                return new PassThroughCompressor();
            }
            case SNAPPY: {
                return new SnappyCompressor();
            }
        }
        throw new IllegalArgumentException("Illegal compressor name " + (Object)((Object)compressionType));
    }

    public static ChunkDecompressor getDecompressor(CompressionType compressionType) {
        switch (compressionType) {
            case PASS_THROUGH: {
                return new PassThroughDecompressor();
            }
            case SNAPPY: {
                return new SnappyDecompressor();
            }
        }
        throw new IllegalArgumentException("Illegal compressor name " + (Object)((Object)compressionType));
    }

    public static enum CompressionType {
        PASS_THROUGH(0),
        SNAPPY(1);

        private final int _value;

        private CompressionType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }
}

