/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl;

import java.io.Closeable;
import java.io.IOException;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedByteSingleValueMultiColReader
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedByteSingleValueMultiColReader.class);
    private final int rows;
    private final int[] colOffSets;
    private int rowSize;
    private PinotDataBuffer indexDataBuffer;
    private final int[] columnSizes;

    public FixedByteSingleValueMultiColReader(PinotDataBuffer pinotDataBuffer, int rows, int[] columnSizes) {
        this.rows = rows;
        this.columnSizes = columnSizes;
        this.colOffSets = new int[columnSizes.length];
        this.rowSize = 0;
        for (int i = 0; i < columnSizes.length; ++i) {
            this.colOffSets[i] = this.rowSize;
            this.rowSize += columnSizes[i];
        }
        this.indexDataBuffer = pinotDataBuffer;
    }

    private int computeOffset(int row, int col) {
        int offset = row * this.rowSize + this.colOffSets[col];
        return offset;
    }

    public char getChar(int row, int col) {
        int offset = this.computeOffset(row, col);
        return this.indexDataBuffer.getChar(offset);
    }

    public short getShort(int row, int col) {
        int offset = this.computeOffset(row, col);
        return this.indexDataBuffer.getShort(offset);
    }

    public int getInt(int row, int col) {
        assert (this.getColumnSizes()[col] == 4);
        int offset = this.computeOffset(row, col);
        return this.indexDataBuffer.getInt(offset);
    }

    public long getLong(int row, int col) {
        assert (this.getColumnSizes()[col] == 8);
        int offset = this.computeOffset(row, col);
        return this.indexDataBuffer.getLong(offset);
    }

    public float getFloat(int row, int col) {
        assert (this.getColumnSizes()[col] == 4);
        int offset = this.computeOffset(row, col);
        return this.indexDataBuffer.getFloat(offset);
    }

    public double getDouble(int row, int col) {
        assert (this.getColumnSizes()[col] == 8);
        int offset = this.computeOffset(row, col);
        return this.indexDataBuffer.getDouble(offset);
    }

    public String getString(int row, int col) {
        return StringUtil.decodeUtf8(this.getBytes(row, col));
    }

    public byte[] getBytes(int row, int col) {
        int length = this.getColumnSizes()[col];
        byte[] dst = new byte[length];
        int offset = this.computeOffset(row, col);
        this.indexDataBuffer.copyTo((long)offset, dst, 0, length);
        return dst;
    }

    public int getNumberOfRows() {
        return this.rows;
    }

    public int[] getColumnSizes() {
        return this.columnSizes;
    }

    @Override
    public void close() throws IOException {
        this.indexDataBuffer.close();
    }

    public boolean open() {
        return false;
    }

    public void readIntValues(int[] rows, int col, int startPos, int limit, int[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getInt(rows[iter], col);
        }
    }

    public void readLongValues(int[] rows, int col, int startPos, int limit, long[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getLong(rows[iter], col);
        }
    }

    public void readFloatValues(int[] rows, int col, int startPos, int limit, float[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getFloat(rows[iter], col);
        }
    }

    public void readDoubleValues(int[] rows, int col, int startPos, int limit, double[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getDouble(rows[iter], col);
        }
    }

    public void readStringValues(int[] rows, int col, int startPos, int limit, String[] values, int outStartPos) {
        int endPos = startPos + limit;
        for (int iter = startPos; iter < endPos; ++iter) {
            values[outStartPos++] = this.getString(rows[iter], col);
        }
    }
}

