/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.io.compression.ChunkDecompressor;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.BaseSingleColumnSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.ChunkReaderContext;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChunkSingleValueReader
extends BaseSingleColumnSingleValueReader<ChunkReaderContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChunkSingleValueReader.class);
    protected final PinotDataBuffer _dataBuffer;
    protected final PinotDataBuffer _dataHeader;
    protected final int _chunkSize;
    private final PinotDataBuffer _rawData;
    private final boolean _isCompressed;
    protected ChunkDecompressor _chunkDecompressor;
    protected final int _numDocsPerChunk;
    protected final int _numChunks;
    protected final int _lengthOfLongestEntry;

    public BaseChunkSingleValueReader(PinotDataBuffer pinotDataBuffer) {
        this._dataBuffer = pinotDataBuffer;
        int headerOffset = 0;
        int version = this._dataBuffer.getInt(headerOffset);
        this._numChunks = this._dataBuffer.getInt(headerOffset += 4);
        this._numDocsPerChunk = this._dataBuffer.getInt(headerOffset += 4);
        this._lengthOfLongestEntry = this._dataBuffer.getInt(headerOffset += 4);
        int dataHeaderStart = headerOffset += 4;
        if (version > 1) {
            this._dataBuffer.getInt(headerOffset);
            ChunkCompressorFactory.CompressionType compressionType = ChunkCompressorFactory.CompressionType.values()[this._dataBuffer.getInt(headerOffset += 4)];
            this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(compressionType);
            this._isCompressed = !compressionType.equals((Object)ChunkCompressorFactory.CompressionType.PASS_THROUGH);
            dataHeaderStart = this._dataBuffer.getInt(headerOffset += 4);
        } else {
            this._isCompressed = true;
            this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(ChunkCompressorFactory.CompressionType.SNAPPY);
        }
        this._chunkSize = this._lengthOfLongestEntry * this._numDocsPerChunk;
        int dataHeaderLength = this._numChunks * 4;
        int rawDataStart = dataHeaderStart + dataHeaderLength;
        this._dataHeader = this._dataBuffer.view(dataHeaderStart, rawDataStart);
        this._rawData = this._dataBuffer.view(rawDataStart, this._dataBuffer.size());
    }

    @Override
    public void close() throws IOException {
        this._dataBuffer.close();
    }

    protected ByteBuffer getChunkForRow(int row, ChunkReaderContext context) {
        int chunkSize;
        int chunkId = row / this._numDocsPerChunk;
        if (context.getChunkId() == chunkId) {
            return context.getChunkBuffer();
        }
        int chunkPosition = this.getChunkPosition(chunkId);
        if (chunkId == this._numChunks - 1) {
            chunkSize = (int)(this._dataBuffer.size() - (long)chunkPosition);
        } else {
            int nextChunkOffset = this.getChunkPosition(chunkId + 1);
            chunkSize = nextChunkOffset - chunkPosition;
        }
        ByteBuffer decompressedBuffer = context.getChunkBuffer();
        decompressedBuffer.clear();
        try {
            this._chunkDecompressor.decompress(this._dataBuffer.toDirectByteBuffer(chunkPosition, chunkSize), decompressedBuffer);
        }
        catch (IOException e) {
            LOGGER.error("Exception caught while decompressing data chunk", (Throwable)e);
            throw new RuntimeException(e);
        }
        context.setChunkId(chunkId);
        return decompressedBuffer;
    }

    protected int getChunkPosition(int chunkId) {
        return this._dataHeader.getInt(chunkId * 4);
    }

    protected boolean isCompressed() {
        return this._isCompressed;
    }

    protected PinotDataBuffer getRawData() {
        return this._rawData;
    }
}

