/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1;

import java.io.IOException;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.BaseSingleColumnMultiValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.ReaderContext;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.PinotDataBitSet;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public final class FixedBitMultiValueReader
extends BaseSingleColumnMultiValueReader<Context> {
    private static final int PREFERRED_NUM_VALUES_PER_CHUNK = 2048;
    private final PinotDataBuffer _dataBuffer;
    private final FixedByteValueReaderWriter _chunkOffsetReader;
    private final PinotDataBitSet _bitmapReader;
    private final FixedBitIntReaderWriter _rawDataReader;
    private final int _numRows;
    private final int _numValues;
    private final int _numRowsPerChunk;

    public FixedBitMultiValueReader(PinotDataBuffer dataBuffer, int numRows, int numValues, int numBitsPerValue) {
        this._dataBuffer = dataBuffer;
        this._numRows = numRows;
        this._numValues = numValues;
        this._numRowsPerChunk = (int)Math.ceil(2048.0f / (float)(numValues / numRows));
        int numChunks = (numRows + this._numRowsPerChunk - 1) / this._numRowsPerChunk;
        long endOffset = numChunks * 4;
        this._chunkOffsetReader = new FixedByteValueReaderWriter(dataBuffer.view(0L, endOffset));
        int bitmapSize = (numValues + 8 - 1) / 8;
        this._bitmapReader = new PinotDataBitSet(dataBuffer.view(endOffset, endOffset + (long)bitmapSize));
        int rawDataSize = (int)(((long)numValues * (long)numBitsPerValue + 8L - 1L) / 8L);
        this._rawDataReader = new FixedBitIntReaderWriter(dataBuffer.view(endOffset += (long)bitmapSize, endOffset + (long)rawDataSize), numValues, numBitsPerValue);
    }

    @Override
    public int getIntArray(int row, int[] intArray) {
        int chunkId = row / this._numRowsPerChunk;
        int chunkOffset = this._chunkOffsetReader.getInt(chunkId);
        int indexInChunk = row % this._numRowsPerChunk;
        int startIndex = indexInChunk == 0 ? chunkOffset : this._bitmapReader.getNextNthSetBitOffset(chunkOffset + 1, indexInChunk);
        int endIndex = row == this._numRows - 1 ? this._numValues : this._bitmapReader.getNextSetBitOffset(startIndex + 1);
        int numValues = endIndex - startIndex;
        this._rawDataReader.readInt(startIndex, numValues, intArray);
        return numValues;
    }

    @Override
    public int getIntArray(int row, int[] intArray, Context context) {
        int startIndex;
        int contextRow = context._row;
        int contextEndOffset = context._endOffset;
        if (row == contextRow + 1) {
            startIndex = contextEndOffset;
        } else {
            int chunkId = row / this._numRowsPerChunk;
            if (row > contextRow && chunkId == contextRow / this._numRowsPerChunk) {
                startIndex = this._bitmapReader.getNextNthSetBitOffset(contextEndOffset + 1, row - contextRow - 1);
            } else {
                int chunkOffset = this._chunkOffsetReader.getInt(chunkId);
                int indexInChunk = row % this._numRowsPerChunk;
                startIndex = indexInChunk == 0 ? chunkOffset : this._bitmapReader.getNextNthSetBitOffset(chunkOffset + 1, indexInChunk);
            }
        }
        int endIndex = row == this._numRows - 1 ? this._numValues : this._bitmapReader.getNextSetBitOffset(startIndex + 1);
        int numValues = endIndex - startIndex;
        this._rawDataReader.readInt(startIndex, numValues, intArray);
        context._row = row;
        context._endOffset = endIndex;
        return numValues;
    }

    @Override
    public Context createContext() {
        return new Context();
    }

    @Override
    public void close() throws IOException {
        this._chunkOffsetReader.close();
        this._bitmapReader.close();
        this._rawDataReader.close();
        this._dataBuffer.close();
    }

    public static class Context
    implements ReaderContext {
        public int _row = -1;
        public int _endOffset = 0;
    }
}

