/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1;

import java.nio.ByteBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.ChunkReaderContext;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.BaseChunkSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class FixedByteChunkSingleValueReader
extends BaseChunkSingleValueReader {
    private final ThreadLocal<byte[]> _reusableBytes = ThreadLocal.withInitial(() -> new byte[this._lengthOfLongestEntry]);

    public FixedByteChunkSingleValueReader(PinotDataBuffer pinotDataBuffer) {
        super(pinotDataBuffer);
    }

    @Override
    public int getInt(int row) {
        if (!this.isCompressed()) {
            return this.getRawData().getInt(row * 4);
        }
        throw new UnsupportedOperationException("Read without context not supported for compressed data.");
    }

    @Override
    public int getInt(int row, ChunkReaderContext context) {
        assert (this._lengthOfLongestEntry == 4);
        int chunkRowId = row % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkForRow(row, context);
        return chunkBuffer.getInt(chunkRowId * 4);
    }

    @Override
    public float getFloat(int row) {
        if (!this.isCompressed()) {
            return this.getRawData().getFloat(row * 4);
        }
        throw new UnsupportedOperationException("Read without context not supported for compressed data.");
    }

    @Override
    public float getFloat(int row, ChunkReaderContext context) {
        assert (this._lengthOfLongestEntry == 4);
        int chunkRowId = row % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkForRow(row, context);
        return chunkBuffer.getFloat(chunkRowId * 4);
    }

    @Override
    public long getLong(int row) {
        if (!this.isCompressed()) {
            return this.getRawData().getLong(row * 8);
        }
        throw new UnsupportedOperationException("Read without context not supported for compressed data.");
    }

    @Override
    public long getLong(int row, ChunkReaderContext context) {
        assert (this._lengthOfLongestEntry == 8);
        int chunkRowId = row % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkForRow(row, context);
        return chunkBuffer.getLong(chunkRowId * 8);
    }

    @Override
    public double getDouble(int row) {
        if (!this.isCompressed()) {
            return this.getRawData().getDouble(row * 8);
        }
        throw new UnsupportedOperationException("Read without context not supported for compressed data.");
    }

    @Override
    public double getDouble(int row, ChunkReaderContext context) {
        assert (this._lengthOfLongestEntry == 8);
        int chunkRowId = row % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkForRow(row, context);
        return chunkBuffer.getDouble(chunkRowId * 8);
    }

    @Override
    public byte[] getBytes(int row) {
        if (!this.isCompressed()) {
            byte[] bytes = this._reusableBytes.get();
            this.getRawData().copyTo((long)(row * this._lengthOfLongestEntry), bytes, 0, this._lengthOfLongestEntry);
            return bytes;
        }
        throw new UnsupportedOperationException("Read without context not supported for compressed data.");
    }

    @Override
    public byte[] getBytes(int row, ChunkReaderContext context) {
        int chunkRowId = row % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkForRow(row, context);
        byte[] bytes = this._reusableBytes.get();
        chunkBuffer.position(chunkRowId * this._lengthOfLongestEntry);
        chunkBuffer.get(bytes);
        return bytes;
    }

    @Override
    public ChunkReaderContext createContext() {
        return new ChunkReaderContext(this._chunkSize);
    }
}

