/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1;

import java.nio.ByteBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.ChunkReaderContext;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.BaseChunkSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.utils.StringUtil;

public class VarByteChunkSingleValueReader
extends BaseChunkSingleValueReader {
    private final int _maxChunkSize;
    private final ThreadLocal<byte[]> _reusableBytes = ThreadLocal.withInitial(() -> new byte[this._lengthOfLongestEntry]);

    public VarByteChunkSingleValueReader(PinotDataBuffer pinotDataBuffer) {
        super(pinotDataBuffer);
        int chunkHeaderSize = this._numDocsPerChunk * 4;
        this._maxChunkSize = chunkHeaderSize + this._lengthOfLongestEntry * this._numDocsPerChunk;
    }

    @Override
    public String getString(int row) {
        return this.getString(row, this.createContext());
    }

    @Override
    public String getString(int row, ChunkReaderContext context) {
        int chunkRowId = row % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkForRow(row, context);
        int rowOffset = chunkBuffer.getInt(chunkRowId * 4);
        int nextRowOffset = this.getNextRowOffset(chunkRowId, chunkBuffer);
        int length = nextRowOffset - rowOffset;
        byte[] bytes = this._reusableBytes.get();
        chunkBuffer.position(rowOffset);
        chunkBuffer.get(bytes, 0, length);
        return StringUtil.decodeUtf8(bytes, 0, length);
    }

    @Override
    public byte[] getBytes(int row) {
        return this.getBytes(row, this.createContext());
    }

    @Override
    public byte[] getBytes(int row, ChunkReaderContext context) {
        int chunkRowId = row % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkForRow(row, context);
        int rowOffset = chunkBuffer.getInt(chunkRowId * 4);
        int nextRowOffset = this.getNextRowOffset(chunkRowId, chunkBuffer);
        int length = nextRowOffset - rowOffset;
        byte[] bytes = new byte[length];
        chunkBuffer.position(rowOffset);
        chunkBuffer.get(bytes, 0, length);
        return bytes;
    }

    @Override
    public ChunkReaderContext createContext() {
        return new ChunkReaderContext(this._maxChunkSize);
    }

    private int getNextRowOffset(int currentRowId, ByteBuffer chunkBuffer) {
        int nextRowOffset;
        if (currentRowId == this._numDocsPerChunk - 1) {
            nextRowOffset = chunkBuffer.limit();
        } else {
            nextRowOffset = chunkBuffer.getInt((currentRowId + 1) * 4);
            if (nextRowOffset == 0) {
                nextRowOffset = chunkBuffer.limit();
            }
        }
        return nextRowOffset;
    }
}

