/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.FixedByteSingleValueMultiColReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.BaseSingleColumnSingleValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.FixedByteSingleValueMultiColWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedByteSingleColumnSingleValueReaderWriter
extends BaseSingleColumnSingleValueReaderWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedByteSingleColumnSingleValueReaderWriter.class);
    private List<WriterWithOffset> _writers = new ArrayList<WriterWithOffset>();
    private List<ReaderWithOffset> _readers = new ArrayList<ReaderWithOffset>();
    private List<PinotDataBuffer> _dataBuffers = new ArrayList<PinotDataBuffer>();
    private final long _chunkSizeInBytes;
    private final int _numRowsPerChunk;
    private final int _columnSizesInBytes;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final String _allocationContext;
    private int _capacityInRows = 0;

    public FixedByteSingleColumnSingleValueReaderWriter(int numRowsPerChunk, int columnSizesInBytes, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        this._chunkSizeInBytes = numRowsPerChunk * columnSizesInBytes;
        this._numRowsPerChunk = numRowsPerChunk;
        this._columnSizesInBytes = columnSizesInBytes;
        this._memoryManager = memoryManager;
        this._allocationContext = allocationContext;
        this.addBuffer();
    }

    @Override
    public void close() throws IOException {
        for (ReaderWithOffset reader : this._readers) {
            reader.close();
        }
        for (WriterWithOffset writer : this._writers) {
            writer.close();
        }
        for (PinotDataBuffer buffer : this._dataBuffers) {
            buffer.close();
        }
    }

    @Override
    public void setInt(int row, int i) {
        this.addBufferIfNeeded(row);
        this.getWriterForRow(row).setInt(row, i);
    }

    @Override
    public void setLong(int row, long l) {
        this.addBufferIfNeeded(row);
        this.getWriterForRow(row).setLong(row, l);
    }

    @Override
    public void setFloat(int row, float f) {
        this.addBufferIfNeeded(row);
        this.getWriterForRow(row).setFloat(row, f);
    }

    @Override
    public void setDouble(int row, double d) {
        this.addBufferIfNeeded(row);
        this.getWriterForRow(row).setDouble(row, d);
    }

    private WriterWithOffset getWriterForRow(int row) {
        return this._writers.get(this.getBufferId(row));
    }

    @Override
    public int getInt(int row) {
        int bufferId = this.getBufferId(row);
        return this._readers.get(bufferId).getInt(row);
    }

    @Override
    public long getLong(int row) {
        int bufferId = this.getBufferId(row);
        return this._readers.get(bufferId).getLong(row);
    }

    @Override
    public float getFloat(int row) {
        int bufferId = this.getBufferId(row);
        return this._readers.get(bufferId).getFloat(row);
    }

    @Override
    public double getDouble(int row) {
        int bufferId = this.getBufferId(row);
        return this._readers.get(bufferId).getDouble(row);
    }

    @Override
    public void readValues(int[] rows, int rowStartPos, int rowSize, int[] values, int valuesStartPos) {
        if (this._readers.size() == 1) {
            this._readers.get(0).getReader().readIntValues(rows, 0, rowStartPos, rowSize, values, valuesStartPos);
        } else {
            int rowIter = rowStartPos;
            int valueIter = valuesStartPos;
            while (rowIter < rowStartPos + rowSize) {
                int row = rows[rowIter];
                int bufferId = this.getBufferId(row);
                values[valueIter] = this._readers.get(bufferId).getInt(row);
                ++rowIter;
                ++valueIter;
            }
        }
    }

    private int getBufferId(int row) {
        return row / this._numRowsPerChunk;
    }

    private void addBuffer() {
        LOGGER.info("Allocating {} bytes for: {}", (Object)this._chunkSizeInBytes, (Object)this._allocationContext);
        PinotDataBuffer buffer = this._memoryManager.allocate(this._chunkSizeInBytes, this._allocationContext);
        this._dataBuffers.add(buffer);
        this._capacityInRows += this._numRowsPerChunk;
        FixedByteSingleValueMultiColReader reader = new FixedByteSingleValueMultiColReader(buffer, this._numRowsPerChunk, new int[]{this._columnSizesInBytes});
        FixedByteSingleValueMultiColWriter writer = new FixedByteSingleValueMultiColWriter(buffer, 1, new int[]{this._columnSizesInBytes});
        int startRowId = this._numRowsPerChunk * (this._dataBuffers.size() - 1);
        this._writers.add(new WriterWithOffset(writer, startRowId));
        this._readers.add(new ReaderWithOffset(reader, startRowId));
    }

    private void addBufferIfNeeded(int row) {
        if (row >= this._capacityInRows) {
            long buffersNeeded = (row + 1 - this._capacityInRows + this._numRowsPerChunk) / this._numRowsPerChunk;
            int i = 0;
            while ((long)i < buffersNeeded) {
                this.addBuffer();
                ++i;
            }
        }
    }

    private static class ReaderWithOffset
    implements Closeable {
        final FixedByteSingleValueMultiColReader _reader;
        final int _startRowId;

        private ReaderWithOffset(FixedByteSingleValueMultiColReader reader, int startRowId) {
            this._reader = reader;
            this._startRowId = startRowId;
        }

        @Override
        public void close() throws IOException {
            this._reader.close();
        }

        public int getInt(int row) {
            return this._reader.getInt(row - this._startRowId, 0);
        }

        public long getLong(int row) {
            return this._reader.getLong(row - this._startRowId, 0);
        }

        public float getFloat(int row) {
            return this._reader.getFloat(row - this._startRowId, 0);
        }

        public double getDouble(int row) {
            return this._reader.getDouble(row - this._startRowId, 0);
        }

        public FixedByteSingleValueMultiColReader getReader() {
            return this._reader;
        }
    }

    private static class WriterWithOffset
    implements Closeable {
        final FixedByteSingleValueMultiColWriter _writer;
        final int _startRowId;

        private WriterWithOffset(FixedByteSingleValueMultiColWriter writer, int startRowId) {
            this._writer = writer;
            this._startRowId = startRowId;
        }

        @Override
        public void close() throws IOException {
            this._writer.close();
        }

        public void setInt(int row, int value) {
            this._writer.setInt(row - this._startRowId, 0, value);
        }

        public void setLong(int row, long value) {
            this._writer.setLong(row - this._startRowId, 0, value);
        }

        public void setFloat(int row, float value) {
            this._writer.setFloat(row - this._startRowId, 0, value);
        }

        public void setDouble(int row, double value) {
            this._writer.setDouble(row - this._startRowId, 0, value);
        }
    }
}

