/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.ValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.utils.StringUtil;

public final class FixedByteValueReaderWriter
implements Closeable,
ValueReader {
    private final PinotDataBuffer _dataBuffer;

    public FixedByteValueReaderWriter(PinotDataBuffer dataBuffer) {
        this._dataBuffer = dataBuffer;
    }

    @Override
    public int getInt(int index) {
        return this._dataBuffer.getInt((long)index * 4L);
    }

    @Override
    public long getLong(int index) {
        return this._dataBuffer.getLong((long)index * 8L);
    }

    @Override
    public float getFloat(int index) {
        return this._dataBuffer.getFloat((long)index * 4L);
    }

    @Override
    public double getDouble(int index) {
        return this._dataBuffer.getDouble((long)index * 8L);
    }

    @Override
    public String getUnpaddedString(int index, int numBytesPerValue, byte paddingByte, byte[] buffer) {
        assert (buffer.length >= numBytesPerValue);
        long startOffset = (long)index * (long)numBytesPerValue;
        for (int i = 0; i < numBytesPerValue; ++i) {
            byte currentByte = this._dataBuffer.getByte(startOffset + (long)i);
            if (currentByte == paddingByte) {
                return StringUtil.decodeUtf8(buffer, 0, i);
            }
            buffer[i] = currentByte;
        }
        return StringUtil.decodeUtf8(buffer, 0, numBytesPerValue);
    }

    @Override
    public String getPaddedString(int index, int numBytesPerValue, byte[] buffer) {
        assert (buffer.length >= numBytesPerValue);
        long startOffset = (long)index * (long)numBytesPerValue;
        this._dataBuffer.copyTo(startOffset, buffer, 0, numBytesPerValue);
        return StringUtil.decodeUtf8(buffer, 0, numBytesPerValue);
    }

    @Override
    public byte[] getBytes(int index, int numBytesPerValue, byte[] buffer) {
        assert (buffer.length >= numBytesPerValue);
        long startOffset = (long)index * (long)numBytesPerValue;
        this._dataBuffer.copyTo(startOffset, buffer, 0, numBytesPerValue);
        return buffer;
    }

    public void writeInt(int index, int value) {
        this._dataBuffer.putInt((long)index * 4L, value);
    }

    public void writeLong(int index, long value) {
        this._dataBuffer.putLong((long)index * 8L, value);
    }

    public void writeFloat(int index, float value) {
        this._dataBuffer.putFloat((long)index * 4L, value);
    }

    public void writeDouble(int index, double value) {
        this._dataBuffer.putDouble((long)index * 8L, value);
    }

    public void writeUnpaddedString(int index, int numBytesPerValue, byte[] value) {
        assert (value.length <= numBytesPerValue);
        long startIndex = (long)index * (long)numBytesPerValue;
        if (value.length < numBytesPerValue) {
            value = Arrays.copyOf(value, numBytesPerValue);
        }
        this._dataBuffer.readFrom(startIndex, value);
    }

    @Override
    public void close() throws IOException {
        this._dataBuffer.close();
    }
}

