/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableOffHeapByteArrayStore
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutableOffHeapByteArrayStore.class);
    private volatile List<Buffer> _buffers = new LinkedList<Buffer>();
    private int _numElements = 0;
    private volatile Buffer _currentBuffer;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final String _allocationContext;
    private long _totalStringSize = 0L;
    private final int _startSize;

    @VisibleForTesting
    public int getStartSize() {
        return this._startSize;
    }

    public MutableOffHeapByteArrayStore(PinotDataBufferMemoryManager memoryManager, String allocationContext, int numArrays, int avgArrayLen) {
        this._memoryManager = memoryManager;
        this._allocationContext = allocationContext;
        this._startSize = numArrays * (avgArrayLen + 4);
        this.expand(this._startSize, 0L);
    }

    private Buffer expand(long suggestedSize, long minSize) {
        Buffer buffer = new Buffer(Math.max(suggestedSize, minSize), this._numElements, this._memoryManager, this._allocationContext);
        LinkedList<Buffer> newList = new LinkedList<Buffer>();
        for (Buffer b : this._buffers) {
            newList.add(b);
        }
        newList.add(buffer);
        this._buffers = newList;
        this._currentBuffer = buffer;
        return buffer;
    }

    private Buffer expand(long sizeOfNewValue) {
        return this.expand(this._currentBuffer.getSize() * 2L, sizeOfNewValue + 4L);
    }

    public byte[] get(int index) {
        List<Buffer> bufList = this._buffers;
        for (int x = bufList.size() - 1; x >= 0; --x) {
            Buffer buffer = bufList.get(x);
            if (index < buffer.getStartIndex()) continue;
            return buffer.get(index - buffer.getStartIndex());
        }
        throw new RuntimeException("dictionary ID '" + index + "' too low");
    }

    public int add(byte[] value) {
        this._totalStringSize += (long)value.length;
        Buffer buffer = this._currentBuffer;
        int index = buffer.add(value);
        if (index < 0) {
            buffer = this.expand(value.length);
            index = buffer.add(value);
        }
        ++this._numElements;
        return index + buffer.getStartIndex();
    }

    public boolean equalsValueAt(byte[] value, int index) {
        List<Buffer> bufList = this._buffers;
        for (int x = bufList.size() - 1; x >= 0; --x) {
            Buffer buffer = bufList.get(x);
            if (index < buffer.getStartIndex()) continue;
            return buffer.equalsValueAt(value, index - buffer.getStartIndex());
        }
        throw new RuntimeException("dictionary ID '" + index + "' too low");
    }

    @Override
    public void close() throws IOException {
        this._numElements = 0;
        for (Buffer buffer : this._buffers) {
            buffer.close();
        }
        this._buffers.clear();
    }

    public long getTotalOffHeapMemUsed() {
        long ret = 0L;
        for (Buffer buffer : this._buffers) {
            ret += buffer.getSize();
        }
        return ret;
    }

    public long getAvgValueSize() {
        if (this._numElements > 0) {
            return this._totalStringSize / (long)this._numElements;
        }
        return 0L;
    }

    private static class Buffer
    implements Closeable {
        private final PinotDataBuffer _pinotDataBuffer;
        private final ByteBuffer _byteBuffer;
        private final int _startIndex;
        private final long _size;
        private int _numValues = 0;
        private int _availEndOffset;

        private Buffer(long size, int startIndex, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
            if (size >= Integer.MAX_VALUE) {
                size = 0x7FFFFFFEL;
            }
            LOGGER.info("Allocating byte array store buffer of size {} for: {}", (Object)size, (Object)allocationContext);
            this._pinotDataBuffer = memoryManager.allocate(size, allocationContext);
            this._byteBuffer = this._pinotDataBuffer.toDirectByteBuffer(0L, (int)size);
            this._startIndex = startIndex;
            this._availEndOffset = this._byteBuffer.capacity();
            this._size = size;
        }

        private int add(byte[] value) {
            int startOffset = this._availEndOffset - value.length;
            if (startOffset < (this._numValues + 1) * 4) {
                return -1;
            }
            int i = 0;
            int j = startOffset;
            while (i < value.length) {
                this._byteBuffer.put(j, value[i]);
                ++i;
                ++j;
            }
            this._byteBuffer.putInt(this._numValues * 4, startOffset);
            this._availEndOffset = startOffset;
            return this._numValues++;
        }

        private boolean equalsValueAt(byte[] value, int index) {
            int startOffset = this._byteBuffer.getInt(index * 4);
            int endOffset = this._byteBuffer.capacity();
            if (index > 0) {
                endOffset = this._byteBuffer.getInt((index - 1) * 4);
            }
            if (endOffset - startOffset != value.length) {
                return false;
            }
            int i = 0;
            int j = startOffset;
            while (i < value.length) {
                if (value[i] != this._byteBuffer.get(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }

        private byte[] get(int index) {
            int startOffset = this._byteBuffer.getInt(index * 4);
            int endOffset = this._byteBuffer.capacity();
            if (index > 0) {
                endOffset = this._byteBuffer.getInt((index - 1) * 4);
            }
            byte[] value = new byte[endOffset - startOffset];
            int i = 0;
            int j = startOffset;
            while (i < value.length) {
                value[i] = this._byteBuffer.get(j);
                ++i;
                ++j;
            }
            return value;
        }

        @Override
        public void close() throws IOException {
            this._pinotDataBuffer.close();
        }

        private long getSize() {
            return this._size;
        }

        private int getStartIndex() {
            return this._startIndex;
        }
    }
}

