/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffHeapStringStore
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapStringStore.class);
    private static final int START_SIZE = 32768;
    private volatile List<Buffer> _buffers = new LinkedList<Buffer>();
    private int _numElements = 0;
    private volatile Buffer _currentBuffer;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final String _allocationContext;

    public static int getStartSize() {
        return 32768;
    }

    public OffHeapStringStore(PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        this._memoryManager = memoryManager;
        this._allocationContext = allocationContext;
        this.expand(32768L, 0L);
    }

    private Buffer expand(long suggestedSize, long minSize) {
        Buffer buffer = new Buffer(Math.max(suggestedSize, minSize), this._numElements, this._memoryManager, this._allocationContext);
        LinkedList<Buffer> newList = new LinkedList<Buffer>();
        for (Buffer b : this._buffers) {
            newList.add(b);
        }
        newList.add(buffer);
        this._buffers = newList;
        this._currentBuffer = buffer;
        return buffer;
    }

    private Buffer expand(long sizeOfNewValue) {
        return this.expand(this._currentBuffer.getSize() * 2L, sizeOfNewValue + 4L);
    }

    public String get(int index) {
        List<Buffer> bufList = this._buffers;
        for (int x = bufList.size() - 1; x >= 0; --x) {
            Buffer buffer = bufList.get(x);
            if (index < buffer.getStartIndex()) continue;
            return buffer.get(index - buffer.getStartIndex());
        }
        throw new RuntimeException("dictionary ID '" + index + "' too low");
    }

    public int add(String string) {
        Buffer buffer = this._currentBuffer;
        int index = buffer.add(string);
        if (index < 0) {
            buffer = this.expand(string.length());
            index = buffer.add(string);
        }
        ++this._numElements;
        return index + buffer.getStartIndex();
    }

    @Override
    public void close() throws IOException {
        this._numElements = 0;
        for (Buffer buffer : this._buffers) {
            buffer.close();
        }
        this._buffers.clear();
    }

    private static class Buffer
    implements Closeable {
        private final PinotDataBuffer _pinotDataBuffer;
        private final ByteBuffer _byteBuffer;
        private final int _startIndex;
        private final long _size;
        private int _numStrings = 0;
        private int _availEndOffset;

        private Buffer(long size, int startIndex, PinotDataBufferMemoryManager memoryManager, String columnName) {
            if (size >= Integer.MAX_VALUE) {
                size = 0x7FFFFFFEL;
            }
            LOGGER.info("Allocationg string buffer of size {} for column {}", (Object)size, (Object)columnName);
            this._pinotDataBuffer = memoryManager.allocate(size, columnName);
            this._byteBuffer = this._pinotDataBuffer.toDirectByteBuffer(0L, (int)size);
            this._startIndex = startIndex;
            this._availEndOffset = this._byteBuffer.capacity();
            this._size = size;
        }

        private int add(String string) {
            int startOffset = this._availEndOffset - string.length() * 2;
            if (startOffset < (this._numStrings + 1) * 4) {
                return -1;
            }
            int i = 0;
            int j = startOffset;
            while (i < string.length()) {
                this._byteBuffer.putChar(j, string.charAt(i));
                ++i;
                j += 2;
            }
            this._byteBuffer.putInt(this._numStrings * 4, startOffset);
            this._availEndOffset = startOffset;
            return this._numStrings++;
        }

        private String get(int index) {
            int startOffset = this._byteBuffer.getInt(index * 4);
            int endOffset = this._byteBuffer.capacity();
            if (index > 0) {
                endOffset = this._byteBuffer.getInt((index - 1) * 4);
            }
            char[] chars = new char[(endOffset - startOffset) / 2];
            int i = 0;
            int j = startOffset;
            while (i < chars.length) {
                chars[i] = this._byteBuffer.getChar(j);
                ++i;
                j += 2;
            }
            return new String(chars);
        }

        @Override
        public void close() throws IOException {
            this._pinotDataBuffer.close();
        }

        private long getSize() {
            return this._size;
        }

        private int getStartIndex() {
            return this._startIndex;
        }
    }
}

